/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.common.request;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.ossindex.common.IPackageRequest;
import net.ossindex.common.OssiPackage;
import net.ossindex.common.OssiVulnerability;
import net.ossindex.common.PackageCoordinate;
import net.ossindex.common.filter.IVulnerabilityFilter;
import net.ossindex.common.filter.VulnerabilityFilterFactory;
import net.ossindex.common.request.OssIndexHttpClient;
import net.ossindex.common.request.PackageRequestDto;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageRequestService
implements IPackageRequest {
    private static final Logger LOG = LoggerFactory.getLogger(PackageRequestService.class);
    private static final long FILE_LOCK_WAIT = 1000L;
    private static int MAX_PACKAGES_PER_QUERY = 128;
    private final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private final OssIndexHttpClient client;
    private boolean debug = false;
    private PackageRequestDto.Builder packages = PackageRequestDto.newBuilder();
    private List<List<PackageCoordinate>> paths = new LinkedList<List<PackageCoordinate>>();
    private List<IVulnerabilityFilter> filters = new LinkedList<IVulnerabilityFilter>();
    private File cacheFile;
    private int cacheTimeout = 12;

    public PackageRequestService(OssIndexHttpClient client) {
        this.client = client;
        File home = new File(System.getProperty("user.home"));
        File cacheDir = new File(home, ".ossindex");
        this.cacheFile = new File(cacheDir, "gradle.cache");
    }

    @Override
    public void addVulnerabilityFilter(IVulnerabilityFilter filter) {
        this.filters.add(filter);
    }

    @Override
    public void setCacheFile(String path) {
        this.cacheFile = path != null ? new File(path) : null;
    }

    @Override
    public void setCredentials(String user, String token) {
        this.client.setCredentials(user, token);
    }

    @Override
    public void setMaximumPackagesPerRequest(int count) {
        MAX_PACKAGES_PER_QUERY = count;
    }

    @Override
    public void setCacheTimeout(int hours) {
        this.cacheTimeout = hours;
    }

    @Override
    public OssiPackage add(String type, String namespace, String artifactId, String version) {
        PackageCoordinate pkg = PackageCoordinate.newBuilder().withFormat(type).withNamespace(namespace).withName(artifactId).withVersion(version).build();
        return this.add(Collections.singletonList(pkg));
    }

    @Override
    public OssiPackage add(List<PackageCoordinate> path) {
        if (path != null && !path.isEmpty()) {
            PackageCoordinate pkg = path.get(path.size() - 1);
            OssiPackage desc = new OssiPackage(pkg.getType(), pkg.getNamespace(), pkg.getName(), pkg.getVersion());
            this.packages.withCoordinate(desc.getCoordinates());
            this.paths.add(path);
            return desc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Collection<OssiPackage> run() throws IOException {
        File cacheDir;
        if (this.cacheFile != null && !this.cacheFile.exists() && !(cacheDir = this.cacheFile.getParentFile()).exists()) {
            cacheDir.mkdirs();
        }
        DB db = null;
        if (this.cacheFile != null) {
            try {
                db = DBMaker.fileDB((File)this.cacheFile).transactionEnable().fileLockWait(1000L).make();
            }
            catch (Exception e) {
                LOG.error("Could not create cache file (" + this.cacheFile + "): " + e.getMessage());
                db = DBMaker.memoryDB().make();
            }
        } else {
            db = DBMaker.memoryDB().make();
        }
        HTreeMap cache = db.hashMap("cache").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.STRING).expireAfterCreate((long)this.cacheTimeout, TimeUnit.HOURS).createOrOpen();
        try {
            PackageRequestDto dto = this.packages.build();
            String[] coords = dto.getCoordinates();
            Collection<OssiPackage> results = new HashSet<OssiPackage>();
            int count = 0;
            while (count < coords.length) {
                PackageRequestDto.Builder usePackages = PackageRequestDto.newBuilder();
                while (count < coords.length && usePackages.size() < MAX_PACKAGES_PER_QUERY) {
                    String coord = coords[count++];
                    if (cache.containsKey((Object)(coord = coord.toLowerCase()))) {
                        LOG.debug("Using cache: " + coord);
                        OssiPackage pkg = (OssiPackage)this.gson.fromJson((String)cache.get((Object)coord), OssiPackage.class);
                        results.add(pkg);
                        continue;
                    }
                    LOG.debug("Add to request: " + coord);
                    usePackages.withCoordinate(coord);
                }
                PackageRequestDto useDto = usePackages.build();
                if (useDto.getCoordinates().length <= 0) continue;
                String data = this.gson.toJson((Object)useDto);
                String response = this.client.performPostRequest("component-report", data);
                Type listType = new TypeToken<List<OssiPackage>>(){}.getType();
                Collection newResults = (Collection)this.gson.fromJson(response, listType);
                for (OssiPackage pkg : newResults) {
                    try {
                        results.add(pkg);
                        String cacheCoord = pkg.getCoordinates().toUpperCase();
                        LOG.debug("Adding to cache: " + cacheCoord);
                        cache.put((Object)cacheCoord, (Object)this.gson.toJson((Object)pkg));
                        db.commit();
                    }
                    catch (Exception e) {
                        db.rollback();
                        throw e;
                    }
                }
            }
            Collection<OssiPackage> collection = results = this.filterResults(results);
            return collection;
        }
        finally {
            db.close();
        }
    }

    private Collection<OssiPackage> filterResults(Collection<OssiPackage> pkgs) {
        if (!this.filters.isEmpty()) {
            LinkedList<OssiPackage> results = new LinkedList<OssiPackage>();
            Iterator<OssiPackage> pkgIt = pkgs.iterator();
            Iterator<List<PackageCoordinate>> pathIt = this.paths.iterator();
            while (pkgIt.hasNext()) {
                if (!pathIt.hasNext()) {
                    throw new IllegalArgumentException("Server results do not match request");
                }
                OssiPackage pkg = pkgIt.next();
                List<PackageCoordinate> path = pathIt.next();
                results.add(this.filterPackage(pkg, path));
            }
            return results;
        }
        return pkgs;
    }

    private OssiPackage filterPackage(OssiPackage pkg, List<PackageCoordinate> path) {
        List<OssiVulnerability> vulns = pkg.getVulnerabilities();
        if (vulns != null && !vulns.isEmpty()) {
            OssiPackage.Builder builder = OssiPackage.newBuilder().withCoordinates(pkg.getCoordinates()).withDescription(pkg.getDescription()).withReference(pkg.getReference()).withUnfilteredVulnerabilityMatches(vulns.size());
            LinkedList<OssiVulnerability> filteredVulns = new LinkedList<OssiVulnerability>();
            for (OssiVulnerability vuln : vulns) {
                String vid = vuln.getId();
                for (IVulnerabilityFilter filter : this.filters) {
                    if (VulnerabilityFilterFactory.shouldFilter(filter, path, vid)) continue;
                    filteredVulns.add(vuln);
                }
            }
            builder.withVulnerabilities(filteredVulns);
            return builder.build();
        }
        return pkg;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

