/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.common.filter;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ossindex.common.PackageCoordinate;
import net.ossindex.common.filter.IVulnerabilityFilter;

class VulnerabilityFilterImpl
implements IVulnerabilityFilter {
    private Map<PackageCoordinate, List<Set<PackageCoordinate>>> filteredPackages = new HashMap<PackageCoordinate, List<Set<PackageCoordinate>>>();
    private Map<String, List<Set<PackageCoordinate>>> filteredIssues = new HashMap<String, List<Set<PackageCoordinate>>>();

    VulnerabilityFilterImpl() {
    }

    @Override
    public void ignorePackage(List<PackageCoordinate> pkgs) {
        if (pkgs != null && !pkgs.isEmpty()) {
            PackageCoordinate pkg = pkgs.get(pkgs.size() - 1);
            List<Object> sets = null;
            if (!this.filteredPackages.containsKey(pkg)) {
                sets = new LinkedList();
                this.filteredPackages.put(pkg, sets);
            } else {
                sets = this.filteredPackages.get(pkg);
            }
            HashSet<PackageCoordinate> set = new HashSet<PackageCoordinate>();
            set.addAll(pkgs);
            sets.add(set);
        }
    }

    @Override
    public void ignoreVulnerability(String vid) {
        this.ignoreVulnerability(null, vid);
    }

    @Override
    public void ignoreVulnerability(List<PackageCoordinate> pkgs, String vid) {
        if (vid == null) {
            this.ignorePackage(pkgs);
        }
        List<Object> sets = null;
        if (!this.filteredIssues.containsKey(vid)) {
            sets = new LinkedList();
            this.filteredIssues.put(vid, sets);
        } else {
            sets = this.filteredIssues.get(vid);
        }
        if (pkgs != null) {
            HashSet<PackageCoordinate> set = new HashSet<PackageCoordinate>();
            set.addAll(pkgs);
            sets.add(set);
        } else {
            sets.add(Collections.EMPTY_SET);
        }
    }

    boolean shouldFilter(List<PackageCoordinate> path, String vid) {
        PackageCoordinate pkg;
        HashSet<PackageCoordinate> pkgSet = new HashSet<PackageCoordinate>();
        if (path != null) {
            pkgSet.addAll(path);
        }
        if (path != null && !path.isEmpty() && this.filteredPackages.containsKey(pkg = path.get(path.size() - 1))) {
            List<Set<PackageCoordinate>> sets = this.filteredPackages.get(pkg);
            for (Set<PackageCoordinate> set : sets) {
                if (!set.isEmpty() && !pkgSet.containsAll(set)) continue;
                return true;
            }
        }
        if (vid != null && this.filteredIssues.containsKey(vid)) {
            List<Set<PackageCoordinate>> sets = this.filteredIssues.get(vid);
            for (Set<PackageCoordinate> set : sets) {
                if (!set.isEmpty() && !pkgSet.containsAll(set)) continue;
                return true;
            }
        }
        return false;
    }
}

