/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.common;

import java.util.Objects;
import net.ossindex.version.IVersionRange;
import net.ossindex.version.InvalidRangeException;
import net.ossindex.version.VersionFactory;

public class PackageCoordinate {
    public final String type;
    public final String namespace;
    public final String name;
    public final String version;

    private PackageCoordinate(Builder builder) {
        this.type = builder.format;
        this.namespace = builder.namespace;
        this.name = builder.name;
        this.version = builder.version;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(PackageCoordinate copy) {
        Builder builder = new Builder();
        builder.format = copy.type;
        builder.namespace = copy.namespace;
        builder.name = copy.name;
        builder.version = copy.version;
        return builder;
    }

    public String getType() {
        return this.type;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        int hashcode = Objects.hash(this.type, this.namespace, this.name);
        return hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PackageCoordinate other = (PackageCoordinate)obj;
        if (Objects.equals(this.type, other.type) && Objects.equals(this.namespace, other.namespace) && Objects.equals(this.name, other.name)) {
            if (other.version == null || this.version == null) {
                return true;
            }
            try {
                IVersionRange orange = VersionFactory.getVersionFactory().getRange(other.version);
                IVersionRange range = VersionFactory.getVersionFactory().getRange(this.version);
                if (orange.intersects(range)) {
                    return true;
                }
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public String toString() {
        return "PackageCoordinate{type='" + this.type + '\'' + ", namespace='" + this.namespace + '\'' + ", name='" + this.name + '\'' + ", version='" + this.version + '\'' + '}';
    }

    public static final class Builder {
        private String format;
        private String namespace;
        private String name;
        private String version;

        private Builder() {
        }

        public Builder withFormat(String val) {
            this.format = val == null || val.trim().isEmpty() ? null : val;
            return this;
        }

        public Builder withNamespace(String val) {
            this.namespace = val == null || val.trim().isEmpty() ? null : val;
            return this;
        }

        public Builder withName(String val) {
            this.name = val == null || val.trim().isEmpty() ? null : val;
            return this;
        }

        public Builder withVersion(String val) {
            this.version = val == null || val.trim().isEmpty() ? null : val;
            return this;
        }

        public PackageCoordinate build() {
            return new PackageCoordinate(this);
        }
    }
}

