/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification.argumentmatching;

import java.util.LinkedList;
import java.util.List;
import org.mockito.ArgumentMatcher;
import org.mockito.internal.matchers.ContainsExtraTypeInfo;

public class ArgumentMatchingTool {
    private ArgumentMatchingTool() {
    }

    public static Integer[] getSuspiciouslyNotMatchingArgsIndexes(List<ArgumentMatcher> matchers, Object[] arguments) {
        if (matchers.size() != arguments.length) {
            return new Integer[0];
        }
        LinkedList<Integer> suspicious = new LinkedList<Integer>();
        int i = 0;
        for (ArgumentMatcher m3 : matchers) {
            if (m3 instanceof ContainsExtraTypeInfo && !ArgumentMatchingTool.safelyMatches(m3, arguments[i]) && ArgumentMatchingTool.toStringEquals(m3, arguments[i]) && !((ContainsExtraTypeInfo)((Object)m3)).typeMatches(arguments[i])) {
                suspicious.add(i);
            }
            ++i;
        }
        return suspicious.toArray(new Integer[0]);
    }

    private static boolean safelyMatches(ArgumentMatcher m3, Object arg) {
        try {
            return m3.matches(arg);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean toStringEquals(ArgumentMatcher m3, Object arg) {
        return m3.toString().equals(arg == null ? "null" : arg.toString());
    }
}

