/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.junit;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.mockito.internal.junit.StubbingHint;
import org.mockito.internal.util.MockitoLogger;
import org.mockito.invocation.Invocation;

class StubbingArgMismatches {
    final Map<Invocation, Set<Invocation>> mismatches = new LinkedHashMap<Invocation, Set<Invocation>>();

    StubbingArgMismatches() {
    }

    public void add(Invocation invocation, Invocation stubbing) {
        Set<Invocation> matchingInvocations = this.mismatches.get(stubbing);
        if (matchingInvocations == null) {
            matchingInvocations = new LinkedHashSet<Invocation>();
            this.mismatches.put(stubbing, matchingInvocations);
        }
        matchingInvocations.add(invocation);
    }

    public void format(String testName, MockitoLogger logger) {
        if (this.mismatches.isEmpty()) {
            return;
        }
        StubbingHint hint = new StubbingHint(testName);
        int x = 1;
        for (Map.Entry<Invocation, Set<Invocation>> m3 : this.mismatches.entrySet()) {
            hint.appendLine(x++, ". Unused... ", m3.getKey().getLocation());
            for (Invocation invocation : m3.getValue()) {
                hint.appendLine(" ...args ok? ", invocation.getLocation());
            }
        }
        logger.log(hint.toString());
    }

    public int size() {
        return this.mismatches.size();
    }

    public String toString() {
        return "" + this.mismatches;
    }
}

