/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.util.Arrays;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.SerializerEightByte;

public class SerializerRecid
extends SerializerEightByte<Long> {
    @Override
    public void serialize(DataOutput2 out, Long value) throws IOException {
        DataIO.packRecid(out, value);
    }

    @Override
    public Long deserialize(DataInput2 in, int available) throws IOException {
        return new Long(DataIO.unpackRecid(in));
    }

    @Override
    public int fixedSize() {
        return -1;
    }

    @Override
    protected Long unpack(long l) {
        return new Long(l);
    }

    @Override
    protected long pack(Long l) {
        return l;
    }

    @Override
    public boolean isTrusted() {
        return true;
    }

    @Override
    public int valueArraySearch(Object keys2, Long key) {
        return Arrays.binarySearch((long[])keys2, key);
    }

    @Override
    public void valueArraySerialize(DataOutput2 out, Object vals) throws IOException {
        for (long o : (long[])vals) {
            DataIO.packRecid(out, o);
        }
    }

    public long[] valueArrayDeserialize(DataInput2 in, int size2) throws IOException {
        long[] ret2 = new long[size2];
        for (int i = 0; i < size2; ++i) {
            ret2[i] = DataIO.unpackRecid(in);
        }
        return ret2;
    }

    @Override
    public Long valueArrayBinaryGet(DataInput2 input, int keysLen, int pos) throws IOException {
        input.unpackLongSkip(pos);
        return this.deserialize(input, -1);
    }
}

