/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import org.mapdb.DBException;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.CompressLZF;
import org.mapdb.serializer.GroupSerializer;

public final class SerializerCompressionWrapper<E>
implements GroupSerializer<E>,
Serializable {
    private static final long serialVersionUID = 4440826457939614346L;
    protected final GroupSerializer<E> serializer;
    protected final ThreadLocal<CompressLZF> LZF = new ThreadLocal<CompressLZF>(){

        @Override
        protected CompressLZF initialValue() {
            return new CompressLZF();
        }
    };

    public SerializerCompressionWrapper(GroupSerializer<E> serializer) {
        this.serializer = serializer;
    }

    @Override
    public void serialize(DataOutput2 out, E value) throws IOException {
        int newLen;
        DataOutput2 out2 = new DataOutput2();
        this.serializer.serialize(out2, value);
        byte[] tmp = new byte[out2.pos + 41];
        try {
            newLen = this.LZF.get().compress(out2.buf, out2.pos, tmp, 0);
        }
        catch (IndexOutOfBoundsException e) {
            newLen = 0;
        }
        if (newLen >= out2.pos || newLen == 0) {
            out.packInt(0);
            out.write(out2.buf, 0, out2.pos);
            return;
        }
        out.packInt(out2.pos + 1);
        out.write(tmp, 0, newLen);
    }

    @Override
    public E deserialize(DataInput2 in, int available) throws IOException {
        int unpackedSize = in.unpackInt() - 1;
        if (unpackedSize == -1) {
            return (E)this.serializer.deserialize(in, available > 0 ? available - 1 : available);
        }
        byte[] unpacked = new byte[unpackedSize];
        this.LZF.get().expand(in, unpacked, 0, unpackedSize);
        DataInput2.ByteArray in2 = new DataInput2.ByteArray(unpacked);
        Object ret2 = this.serializer.deserialize(in2, unpackedSize);
        if (in2.pos != unpackedSize) {
            throw new DBException.DataCorruption("data were not fully read");
        }
        return (E)ret2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializerCompressionWrapper that = (SerializerCompressionWrapper)o;
        return this.serializer.equals(that.serializer);
    }

    public int hashCode() {
        return this.serializer.hashCode();
    }

    @Override
    public boolean isTrusted() {
        return true;
    }

    @Override
    public int valueArraySearch(Object keys2, E key) {
        return this.serializer.valueArraySearch(keys2, key);
    }

    @Override
    public int valueArraySearch(Object keys2, E key, Comparator comparator) {
        return this.serializer.valueArraySearch(keys2, key, comparator);
    }

    @Override
    public void valueArraySerialize(DataOutput2 out, Object vals) throws IOException {
        int newLen;
        DataOutput2 out2 = new DataOutput2();
        this.serializer.valueArraySerialize(out2, vals);
        if (out2.pos == 0) {
            return;
        }
        byte[] tmp = new byte[out2.pos + 41];
        try {
            newLen = this.LZF.get().compress(out2.buf, out2.pos, tmp, 0);
        }
        catch (IndexOutOfBoundsException e) {
            newLen = 0;
        }
        if (newLen >= out2.pos || newLen == 0) {
            out.packInt(0);
            out.write(out2.buf, 0, out2.pos);
            return;
        }
        out.packInt(out2.pos + 1);
        out.write(tmp, 0, newLen);
    }

    @Override
    public Object valueArrayDeserialize(DataInput2 in, int size2) throws IOException {
        if (size2 == 0) {
            return this.serializer.valueArrayEmpty();
        }
        int unpackedSize = in.unpackInt() - 1;
        if (unpackedSize == -1) {
            return this.serializer.valueArrayDeserialize(in, size2);
        }
        byte[] unpacked = new byte[unpackedSize];
        this.LZF.get().expand(in, unpacked, 0, unpackedSize);
        DataInput2.ByteArray in2 = new DataInput2.ByteArray(unpacked);
        Object ret2 = this.serializer.valueArrayDeserialize(in2, size2);
        if (in2.pos != unpackedSize) {
            throw new DBException.DataCorruption("data were not fully read");
        }
        return ret2;
    }

    @Override
    public E valueArrayGet(Object vals, int pos) {
        return this.serializer.valueArrayGet(vals, pos);
    }

    @Override
    public int valueArraySize(Object vals) {
        return this.serializer.valueArraySize(vals);
    }

    @Override
    public Object valueArrayEmpty() {
        return this.serializer.valueArrayEmpty();
    }

    @Override
    public Object valueArrayPut(Object vals, int pos, E newValue) {
        return this.serializer.valueArrayPut(vals, pos, newValue);
    }

    @Override
    public Object valueArrayUpdateVal(Object vals, int pos, E newValue) {
        return this.serializer.valueArrayUpdateVal(vals, pos, newValue);
    }

    @Override
    public Object valueArrayFromArray(Object[] objects) {
        return this.serializer.valueArrayFromArray(objects);
    }

    @Override
    public Object valueArrayCopyOfRange(Object vals, int from, int to) {
        return this.serializer.valueArrayCopyOfRange(vals, from, to);
    }

    @Override
    public Object valueArrayDeleteValue(Object vals, int pos) {
        return this.serializer.valueArrayDeleteValue(vals, pos);
    }

    @Override
    public boolean equals(E a1, E a2) {
        return this.serializer.equals(a1, a2);
    }

    @Override
    public int hashCode(E e, int seed) {
        return this.serializer.hashCode(e, seed);
    }

    @Override
    public int compare(E o1, E o2) {
        return this.serializer.compare(o1, o2);
    }
}

