/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner.notification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runner.notification.SynchronizedRunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunNotifier {
    private final List<RunListener> listeners = new CopyOnWriteArrayList<RunListener>();
    private volatile boolean pleaseStop = false;

    public void addListener(RunListener listener2) {
        if (listener2 == null) {
            throw new NullPointerException("Cannot add a null listener");
        }
        this.listeners.add(this.wrapIfNotThreadSafe(listener2));
    }

    public void removeListener(RunListener listener2) {
        if (listener2 == null) {
            throw new NullPointerException("Cannot remove a null listener");
        }
        this.listeners.remove(this.wrapIfNotThreadSafe(listener2));
    }

    RunListener wrapIfNotThreadSafe(RunListener listener2) {
        return listener2.getClass().isAnnotationPresent(RunListener.ThreadSafe.class) ? listener2 : new SynchronizedRunListener(listener2, this);
    }

    public void fireTestRunStarted(final Description description) {
        new SafeNotifier(){

            protected void notifyListener(RunListener each2) throws Exception {
                each2.testRunStarted(description);
            }
        }.run();
    }

    public void fireTestRunFinished(final Result result) {
        new SafeNotifier(){

            protected void notifyListener(RunListener each2) throws Exception {
                each2.testRunFinished(result);
            }
        }.run();
    }

    public void fireTestStarted(final Description description) throws StoppedByUserException {
        if (this.pleaseStop) {
            throw new StoppedByUserException();
        }
        new SafeNotifier(){

            protected void notifyListener(RunListener each2) throws Exception {
                each2.testStarted(description);
            }
        }.run();
    }

    public void fireTestFailure(Failure failure) {
        this.fireTestFailures(this.listeners, Arrays.asList(failure));
    }

    private void fireTestFailures(List<RunListener> listeners, final List<Failure> failures) {
        if (!failures.isEmpty()) {
            new SafeNotifier(listeners){

                protected void notifyListener(RunListener listener2) throws Exception {
                    for (Failure each2 : failures) {
                        listener2.testFailure(each2);
                    }
                }
            }.run();
        }
    }

    public void fireTestAssumptionFailed(final Failure failure) {
        new SafeNotifier(){

            protected void notifyListener(RunListener each2) throws Exception {
                each2.testAssumptionFailure(failure);
            }
        }.run();
    }

    public void fireTestIgnored(final Description description) {
        new SafeNotifier(){

            protected void notifyListener(RunListener each2) throws Exception {
                each2.testIgnored(description);
            }
        }.run();
    }

    public void fireTestFinished(final Description description) {
        new SafeNotifier(){

            protected void notifyListener(RunListener each2) throws Exception {
                each2.testFinished(description);
            }
        }.run();
    }

    public void pleaseStop() {
        this.pleaseStop = true;
    }

    public void addFirstListener(RunListener listener2) {
        if (listener2 == null) {
            throw new NullPointerException("Cannot add a null listener");
        }
        this.listeners.add(0, this.wrapIfNotThreadSafe(listener2));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class SafeNotifier {
        private final List<RunListener> currentListeners;

        SafeNotifier() {
            this(runNotifier.listeners);
        }

        SafeNotifier(List<RunListener> currentListeners) {
            this.currentListeners = currentListeners;
        }

        void run() {
            int capacity = this.currentListeners.size();
            ArrayList<RunListener> safeListeners = new ArrayList<RunListener>(capacity);
            ArrayList<Failure> failures = new ArrayList<Failure>(capacity);
            for (RunListener listener2 : this.currentListeners) {
                try {
                    this.notifyListener(listener2);
                    safeListeners.add(listener2);
                }
                catch (Exception e) {
                    failures.add(new Failure(Description.TEST_MECHANISM, e));
                }
            }
            RunNotifier.this.fireTestFailures(safeListeners, failures);
        }

        protected abstract void notifyListener(RunListener var1) throws Exception;
    }
}

