/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.IntSummaryStatistics;
import java.util.Iterator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.RandomAccess;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.ordered.OrderedIterable;
import org.eclipse.collections.api.tuple.Twin;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.block.procedure.CountProcedure;
import org.eclipse.collections.impl.block.procedure.FastListCollectIfProcedure;
import org.eclipse.collections.impl.block.procedure.FastListCollectProcedure;
import org.eclipse.collections.impl.block.procedure.FastListRejectProcedure;
import org.eclipse.collections.impl.block.procedure.FastListSelectProcedure;
import org.eclipse.collections.impl.block.procedure.MultimapPutProcedure;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ObjectDoubleMaps;
import org.eclipse.collections.impl.factory.primitive.ObjectLongMaps;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectDoubleHashMap;
import org.eclipse.collections.impl.partition.list.PartitionFastList;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.strategy.mutable.UnifiedSetWithHashingStrategy;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.collections.impl.utility.ArrayIterate;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.internal.IterableIterate;

public final class InternalArrayIterate {
    private InternalArrayIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> boolean arrayEqualsList(T[] array, int size2, List<?> list) {
        if (size2 != list.size()) {
            return false;
        }
        if (list instanceof RandomAccess) {
            return InternalArrayIterate.randomAccessListEquals(array, size2, list);
        }
        return InternalArrayIterate.nonRandomAccessListEquals(array, size2, list);
    }

    private static <T> boolean randomAccessListEquals(T[] array, int size2, List<?> list) {
        for (int i = 0; i < size2; ++i) {
            if (Comparators.nullSafeEquals(array[i], list.get(i))) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean nonRandomAccessListEquals(T[] array, int size2, List<?> list) {
        Iterator<?> iterator2 = list.iterator();
        for (int i = 0; i < size2; ++i) {
            if (!iterator2.hasNext()) {
                return false;
            }
            if (Comparators.nullSafeEquals(array[i], iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static <T> void forEachWithoutChecks(T[] objectArray, int from, int to, Procedure<? super T> procedure) {
        if (from <= to) {
            for (int i = from; i <= to; ++i) {
                procedure.value(objectArray[i]);
            }
        } else {
            for (int i = from; i >= to; --i) {
                procedure.value(objectArray[i]);
            }
        }
    }

    public static <T> void forEachWithIndexWithoutChecks(T[] objectArray, int from, int to, ObjectIntProcedure<? super T> objectIntProcedure) {
        if (from <= to) {
            for (int i = from; i <= to; ++i) {
                objectIntProcedure.value(objectArray[i], i);
            }
        } else {
            for (int i = from; i >= to; --i) {
                objectIntProcedure.value(objectArray[i], i);
            }
        }
    }

    public static <T> void batchForEach(Procedure<? super T> procedure, T[] array, int size2, int sectionIndex, int sectionCount) {
        int end;
        int sectionSize = size2 / sectionCount;
        int start = sectionSize * sectionIndex;
        int n = end = sectionIndex == sectionCount - 1 ? size2 : start + sectionSize;
        if (procedure instanceof FastListSelectProcedure) {
            InternalArrayIterate.batchFastListSelect(array, start, end, (FastListSelectProcedure)procedure);
        } else if (procedure instanceof FastListCollectProcedure) {
            InternalArrayIterate.batchFastListCollect(array, start, end, (FastListCollectProcedure)procedure);
        } else if (procedure instanceof FastListCollectIfProcedure) {
            InternalArrayIterate.batchFastListCollectIf(array, start, end, (FastListCollectIfProcedure)procedure);
        } else if (procedure instanceof CountProcedure) {
            InternalArrayIterate.batchCount(array, start, end, (CountProcedure)procedure);
        } else if (procedure instanceof FastListRejectProcedure) {
            InternalArrayIterate.batchReject(array, start, end, (FastListRejectProcedure)procedure);
        } else if (procedure instanceof MultimapPutProcedure) {
            InternalArrayIterate.batchGroupBy(array, start, end, (MultimapPutProcedure)procedure);
        } else {
            for (int i = start; i < end; ++i) {
                procedure.value(array[i]);
            }
        }
    }

    private static <T> void batchGroupBy(T[] array, int start, int end, MultimapPutProcedure<?, T> castProcedure) {
        for (int i = start; i < end; ++i) {
            castProcedure.value(array[i]);
        }
    }

    private static <T> void batchReject(T[] array, int start, int end, FastListRejectProcedure<T> castProcedure) {
        for (int i = start; i < end; ++i) {
            castProcedure.value(array[i]);
        }
    }

    private static <T> void batchCount(T[] array, int start, int end, CountProcedure<T> castProcedure) {
        for (int i = start; i < end; ++i) {
            castProcedure.value(array[i]);
        }
    }

    private static <T> void batchFastListCollectIf(T[] array, int start, int end, FastListCollectIfProcedure<T, ?> castProcedure) {
        for (int i = start; i < end; ++i) {
            castProcedure.value(array[i]);
        }
    }

    private static <T> void batchFastListCollect(T[] array, int start, int end, FastListCollectProcedure<T, ?> castProcedure) {
        for (int i = start; i < end; ++i) {
            castProcedure.value(array[i]);
        }
    }

    private static <T> void batchFastListSelect(T[] array, int start, int end, FastListSelectProcedure<T> castProcedure) {
        for (int i = start; i < end; ++i) {
            castProcedure.value(array[i]);
        }
    }

    public static <T, V, R extends MutableMultimap<V, T>> R groupBy(T[] array, int size2, Function<? super T, ? extends V> function, R target) {
        for (int i = 0; i < size2; ++i) {
            T item = array[i];
            target.put(function.valueOf(item), item);
        }
        return target;
    }

    public static <T, V, R extends MutableMultimap<V, T>> R groupByEach(T[] array, int size2, Function<? super T, ? extends Iterable<V>> function, R target) {
        for (int i = 0; i < size2; ++i) {
            T item = array[i];
            Iterable<V> iterable = function.valueOf(item);
            for (V key : iterable) {
                target.put(key, item);
            }
        }
        return target;
    }

    public static <T, K, R extends MutableMapIterable<K, T>> R groupByUniqueKey(T[] array, int size2, Function<? super T, ? extends K> function, R target) {
        for (int i = 0; i < size2; ++i) {
            T value = array[i];
            K key = function.valueOf(value);
            if (target.put(key, value) == null) continue;
            throw new IllegalStateException("Key " + key + " already exists in map!");
        }
        return target;
    }

    public static <T> PartitionFastList<T> partition(T[] array, int size2, Predicate<? super T> predicate) {
        PartitionFastList partitionFastList = new PartitionFastList();
        for (int i = 0; i < size2; ++i) {
            T each2 = array[i];
            MutableCollection bucket = predicate.accept(each2) ? partitionFastList.getSelected() : partitionFastList.getRejected();
            bucket.add(each2);
        }
        return partitionFastList;
    }

    public static <T, P> PartitionFastList<T> partitionWith(T[] array, int size2, Predicate2<? super T, ? super P> predicate, P parameter) {
        PartitionFastList partitionFastList = new PartitionFastList();
        for (int i = 0; i < size2; ++i) {
            T each2 = array[i];
            MutableCollection bucket = predicate.accept(each2, parameter) ? partitionFastList.getSelected() : partitionFastList.getRejected();
            bucket.add(each2);
        }
        return partitionFastList;
    }

    @Deprecated
    public static <T, P> Twin<MutableList<T>> selectAndRejectWith(T[] objectArray, int size2, Predicate2<? super T, ? super P> predicate, P parameter) {
        MutableList positiveResult = Lists.mutable.empty();
        MutableList negativeResult = Lists.mutable.empty();
        for (int i = 0; i < size2; ++i) {
            T each2 = objectArray[i];
            (predicate.accept(each2, parameter) ? positiveResult : negativeResult).add(each2);
        }
        return Tuples.twin(positiveResult, negativeResult);
    }

    public static int indexOf(Object[] array, int size2, Object object) {
        for (int i = 0; i < size2; ++i) {
            if (!Comparators.nullSafeEquals(array[i], object)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(Object[] array, int size2, Object object) {
        for (int i = size2 - 1; i >= 0; --i) {
            if (!Comparators.nullSafeEquals(array[i], object)) continue;
            return i;
        }
        return -1;
    }

    public static <T, R extends Collection<T>> R select(T[] array, int size2, Predicate<? super T> predicate, R target) {
        for (int i = 0; i < size2; ++i) {
            T item = array[i];
            if (!predicate.accept(item)) continue;
            target.add(item);
        }
        return target;
    }

    public static <T, P, R extends Collection<T>> R selectWith(T[] array, int size2, Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        for (int i = 0; i < size2; ++i) {
            T item = array[i];
            if (!predicate.accept(item, parameter)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <T, R extends Collection<T>> R reject(T[] array, int size2, Predicate<? super T> predicate, R target) {
        for (int i = 0; i < size2; ++i) {
            T item = array[i];
            if (predicate.accept(item)) continue;
            target.add(item);
        }
        return target;
    }

    public static <T, P, R extends Collection<T>> R rejectWith(T[] array, int size2, Predicate2<? super T, ? super P> predicate, P parameter, R target) {
        for (int i = 0; i < size2; ++i) {
            T item = array[i];
            if (predicate.accept(item, parameter)) continue;
            target.add(item);
        }
        return target;
    }

    public static <T> FastList<T> selectInstancesOf(Object[] array, int size2, Class<T> clazz) {
        FastList results = FastList.newList(size2);
        for (int i = 0; i < size2; ++i) {
            Object each2 = array[i];
            if (!clazz.isInstance(each2)) continue;
            results.add(each2);
        }
        return results;
    }

    public static <T, V, R extends Collection<V>> R collect(T[] array, int size2, Function<? super T, ? extends V> function, R target) {
        InternalArrayIterate.ensureCapacityForAdditionalSize(size2, target);
        for (int i = 0; i < size2; ++i) {
            target.add(function.valueOf(array[i]));
        }
        return target;
    }

    public static <T, V, R extends Collection<V>> R collectWithIndex(T[] array, int size2, ObjectIntToObjectFunction<? super T, ? extends V> function, R target) {
        InternalArrayIterate.ensureCapacityForAdditionalSize(size2, target);
        int index = 0;
        for (int i = 0; i < size2; ++i) {
            target.add(function.valueOf(array[i], index++));
        }
        return target;
    }

    private static void ensureCapacityForAdditionalSize(int size2, Collection<?> target) {
        if (target instanceof FastList) {
            ((FastList)target).ensureCapacity(target.size() + size2);
        } else if (target instanceof ArrayList) {
            ((ArrayList)target).ensureCapacity(target.size() + size2);
        }
    }

    public static <T, V, R extends Collection<V>> R flatCollect(T[] array, int size2, Function<? super T, ? extends Iterable<V>> function, R target) {
        for (int i = 0; i < size2; ++i) {
            Iterate.addAllTo(function.valueOf(array[i]), target);
        }
        return target;
    }

    public static <T, P, V, R extends Collection<V>> R collectWith(T[] array, int size2, Function2<? super T, ? super P, ? extends V> function, P parameter, R target) {
        InternalArrayIterate.ensureCapacityForAdditionalSize(size2, target);
        for (int i = 0; i < size2; ++i) {
            target.add(function.value(array[i], parameter));
        }
        return target;
    }

    public static <T, V, R extends Collection<V>> R collectIf(T[] array, int size2, Predicate<? super T> predicate, Function<? super T, ? extends V> function, R target) {
        for (int i = 0; i < size2; ++i) {
            T item = array[i];
            if (!predicate.accept(item)) continue;
            target.add(function.valueOf(item));
        }
        return target;
    }

    public static <T> T min(T[] array, int size2, Comparator<? super T> comparator) {
        if (size2 == 0) {
            throw new NoSuchElementException();
        }
        T min2 = array[0];
        for (int i = 1; i < size2; ++i) {
            T item = array[i];
            if (comparator.compare(item, min2) >= 0) continue;
            min2 = item;
        }
        return min2;
    }

    public static <T> T max(T[] array, int size2, Comparator<? super T> comparator) {
        if (size2 == 0) {
            throw new NoSuchElementException();
        }
        T max2 = array[0];
        for (int i = 1; i < size2; ++i) {
            T item = array[i];
            if (comparator.compare(item, max2) <= 0) continue;
            max2 = item;
        }
        return max2;
    }

    public static <T> T min(T[] array, int size2) {
        if (size2 == 0) {
            throw new NoSuchElementException();
        }
        T min2 = array[0];
        for (int i = 1; i < size2; ++i) {
            T item = array[i];
            if (((Comparable)item).compareTo(min2) >= 0) continue;
            min2 = item;
        }
        return min2;
    }

    public static <T> T max(T[] array, int size2) {
        if (size2 == 0) {
            throw new NoSuchElementException();
        }
        T max2 = array[0];
        for (int i = 1; i < size2; ++i) {
            T item = array[i];
            if (((Comparable)item).compareTo(max2) <= 0) continue;
            max2 = item;
        }
        return max2;
    }

    public static <T, V extends Comparable<? super V>> T minBy(T[] array, int size2, Function<? super T, ? extends V> function) {
        if (ArrayIterate.isEmpty(array)) {
            throw new NoSuchElementException();
        }
        T min2 = array[0];
        Comparable minValue = (Comparable)function.valueOf(min2);
        for (int i = 1; i < size2; ++i) {
            T next = array[i];
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (nextValue.compareTo(minValue) >= 0) continue;
            min2 = next;
            minValue = nextValue;
        }
        return min2;
    }

    public static <T, V extends Comparable<? super V>> T maxBy(T[] array, int size2, Function<? super T, ? extends V> function) {
        if (ArrayIterate.isEmpty(array)) {
            throw new NoSuchElementException();
        }
        T max2 = array[0];
        Comparable maxValue = (Comparable)function.valueOf(max2);
        for (int i = 1; i < size2; ++i) {
            T next = array[i];
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (nextValue.compareTo(maxValue) <= 0) continue;
            max2 = next;
            maxValue = nextValue;
        }
        return max2;
    }

    public static <T> int count(T[] array, int size2, Predicate<? super T> predicate) {
        int count2 = 0;
        for (int i = 0; i < size2; ++i) {
            if (!predicate.accept(array[i])) continue;
            ++count2;
        }
        return count2;
    }

    public static <T, P> int countWith(T[] array, int size2, Predicate2<? super T, ? super P> predicate, P parameter) {
        int count2 = 0;
        for (int i = 0; i < size2; ++i) {
            if (!predicate.accept(array[i], parameter)) continue;
            ++count2;
        }
        return count2;
    }

    public static <T> boolean shortCircuit(T[] array, int size2, Predicate<? super T> predicate, boolean expected, boolean onShortCircuit, boolean atEnd) {
        for (int i = 0; i < size2; ++i) {
            T each2 = array[i];
            if (predicate.accept(each2) != expected) continue;
            return onShortCircuit;
        }
        return atEnd;
    }

    public static <T, P> boolean shortCircuitWith(T[] array, int size2, Predicate2<? super T, ? super P> predicate2, P parameter, boolean expected, boolean onShortCircuit, boolean atEnd) {
        for (int i = 0; i < size2; ++i) {
            T each2 = array[i];
            if (predicate2.accept(each2, parameter) != expected) continue;
            return onShortCircuit;
        }
        return atEnd;
    }

    public static <T, P> boolean corresponds(T[] array, int size2, OrderedIterable<P> other, Predicate2<? super T, ? super P> predicate) {
        if (size2 != other.size()) {
            return false;
        }
        if (other instanceof RandomAccess) {
            List otherList = (List)((Object)other);
            for (int index = 0; index < size2; ++index) {
                if (predicate.accept(array[index], otherList.get(index))) continue;
                return false;
            }
            return true;
        }
        Iterator otherIterator = other.iterator();
        for (int index = 0; index < size2; ++index) {
            if (predicate.accept(array[index], otherIterator.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean anySatisfy(T[] array, int size2, Predicate<? super T> predicate) {
        return InternalArrayIterate.shortCircuit(array, size2, predicate, true, true, false);
    }

    public static <T, P> boolean anySatisfyWith(T[] array, int size2, Predicate2<? super T, ? super P> predicate, P parameter) {
        return InternalArrayIterate.shortCircuitWith(array, size2, predicate, parameter, true, true, false);
    }

    public static <T> boolean allSatisfy(T[] array, int size2, Predicate<? super T> predicate) {
        return InternalArrayIterate.shortCircuit(array, size2, predicate, false, false, true);
    }

    public static <T, P> boolean allSatisfyWith(T[] array, int size2, Predicate2<? super T, ? super P> predicate, P parameter) {
        return InternalArrayIterate.shortCircuitWith(array, size2, predicate, parameter, false, false, true);
    }

    public static <T> boolean noneSatisfy(T[] array, int size2, Predicate<? super T> predicate) {
        return InternalArrayIterate.shortCircuit(array, size2, predicate, true, false, true);
    }

    public static <T, P> boolean noneSatisfyWith(T[] array, int size2, Predicate2<? super T, ? super P> predicate, P parameter) {
        return InternalArrayIterate.shortCircuitWith(array, size2, predicate, parameter, true, false, true);
    }

    public static <T> T detect(T[] array, int size2, Predicate<? super T> predicate) {
        for (int i = 0; i < size2; ++i) {
            T each2 = array[i];
            if (!predicate.accept(each2)) continue;
            return each2;
        }
        return null;
    }

    public static <T, P> T detectWith(T[] array, int size2, Predicate2<? super T, ? super P> predicate, P parameter) {
        for (int i = 0; i < size2; ++i) {
            T each2 = array[i];
            if (!predicate.accept(each2, parameter)) continue;
            return each2;
        }
        return null;
    }

    public static <T> Optional<T> detectOptional(T[] array, int size2, Predicate<? super T> predicate) {
        for (int i = 0; i < size2; ++i) {
            T each2 = array[i];
            if (!predicate.accept(each2)) continue;
            return Optional.of(each2);
        }
        return Optional.empty();
    }

    public static <T, P> Optional<T> detectWithOptional(T[] array, int size2, Predicate2<? super T, ? super P> predicate, P parameter) {
        for (int i = 0; i < size2; ++i) {
            T each2 = array[i];
            if (!predicate.accept(each2, parameter)) continue;
            return Optional.of(each2);
        }
        return Optional.empty();
    }

    public static <T> void appendString(ListIterable<T> iterable, T[] array, int size2, Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            if (size2 > 0) {
                appendable.append(IterableIterate.stringValueOfItem(iterable, array[0]));
                for (int i = 1; i < size2; ++i) {
                    appendable.append(separator);
                    appendable.append(IterableIterate.stringValueOfItem(iterable, array[i]));
                }
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> int detectIndex(T[] objectArray, int size2, Predicate<? super T> predicate) {
        for (int i = 0; i < size2; ++i) {
            if (!predicate.accept(objectArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> int detectLastIndex(T[] objectArray, int size2, Predicate<? super T> predicate) {
        for (int i = size2 - 1; i >= 0; --i) {
            if (!predicate.accept(objectArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> void forEachWithIndex(T[] objectArray, int size2, ObjectIntProcedure<? super T> objectIntProcedure) {
        for (int i = 0; i < size2; ++i) {
            objectIntProcedure.value(objectArray[i], i);
        }
    }

    @Deprecated
    public static <T, R extends List<T>> R distinct(T[] objectArray, int size2, R targetList) {
        UnifiedSet seenSoFar = UnifiedSet.newSet();
        for (int i = 0; i < size2; ++i) {
            T each2 = objectArray[i];
            if (!seenSoFar.add(each2)) continue;
            targetList.add(each2);
        }
        return targetList;
    }

    public static <T> FastList<T> distinct(T[] objectArray, int size2) {
        return InternalArrayIterate.distinct(objectArray, size2, FastList.newList());
    }

    public static <T> FastList<T> distinct(T[] objectArray, int size2, HashingStrategy<? super T> hashingStrategy) {
        UnifiedSetWithHashingStrategy<T> seenSoFar = UnifiedSetWithHashingStrategy.newSet(hashingStrategy);
        FastList result = FastList.newList();
        for (int i = 0; i < size2; ++i) {
            T each2 = objectArray[i];
            if (!seenSoFar.add(each2)) continue;
            result.add(each2);
        }
        return result;
    }

    public static <T> long sumOfInt(T[] array, int size2, IntFunction<? super T> function) {
        long result = 0L;
        for (int i = 0; i < size2; ++i) {
            result += (long)function.intValueOf(array[i]);
        }
        return result;
    }

    public static <T> long sumOfLong(T[] array, int size2, LongFunction<? super T> function) {
        long result = 0L;
        for (int i = 0; i < size2; ++i) {
            result += function.longValueOf(array[i]);
        }
        return result;
    }

    public static <T> double sumOfFloat(T[] array, int size2, FloatFunction<? super T> function) {
        double sum2 = 0.0;
        double compensation = 0.0;
        for (int i = 0; i < size2; ++i) {
            double adjustedValue = (double)function.floatValueOf(array[i]) - compensation;
            double nextSum = sum2 + adjustedValue;
            compensation = nextSum - sum2 - adjustedValue;
            sum2 = nextSum;
        }
        return sum2;
    }

    public static <T> double sumOfDouble(T[] array, int size2, DoubleFunction<? super T> function) {
        double sum2 = 0.0;
        double compensation = 0.0;
        for (int i = 0; i < size2; ++i) {
            double adjustedValue = function.doubleValueOf(array[i]) - compensation;
            double nextSum = sum2 + adjustedValue;
            compensation = nextSum - sum2 - adjustedValue;
            sum2 = nextSum;
        }
        return sum2;
    }

    public static <V, T> MutableObjectLongMap<V> sumByInt(T[] array, int size2, Function<? super T, ? extends V> groupBy, IntFunction<? super T> function) {
        MutableObjectLongMap<V> result = ObjectLongMaps.mutable.empty();
        for (int i = 0; i < size2; ++i) {
            T item = array[i];
            result.addToValue(groupBy.valueOf(item), function.intValueOf(item));
        }
        return result;
    }

    public static <V, T> MutableObjectLongMap<V> sumByLong(T[] array, int size2, Function<? super T, ? extends V> groupBy, LongFunction<? super T> function) {
        MutableObjectLongMap<V> result = ObjectLongMaps.mutable.empty();
        for (int i = 0; i < size2; ++i) {
            T item = array[i];
            result.addToValue(groupBy.valueOf(item), function.longValueOf(item));
        }
        return result;
    }

    public static <V, T> MutableObjectDoubleMap<V> sumByFloat(T[] array, int size2, Function<? super T, ? extends V> groupBy, FloatFunction<? super T> function) {
        MutableObjectDoubleMap<V> result = ObjectDoubleMaps.mutable.empty();
        MutableObjectDoubleMap<V> groupKeyToCompensation = ObjectDoubleMaps.mutable.empty();
        for (int i = 0; i < size2; ++i) {
            T item = array[i];
            V groupByKey = groupBy.valueOf(item);
            double compensation = groupKeyToCompensation.getIfAbsentPut(groupByKey, 0.0);
            double adjustedValue = (double)function.floatValueOf(item) - compensation;
            double nextSum = result.get(groupByKey) + adjustedValue;
            groupKeyToCompensation.put(groupByKey, nextSum - result.get(groupByKey) - adjustedValue);
            result.put(groupByKey, nextSum);
        }
        return result;
    }

    public static <V, T> MutableObjectDoubleMap<V> sumByDouble(T[] array, int size2, Function<? super T, ? extends V> groupBy, DoubleFunction<? super T> function) {
        MutableObjectDoubleMap<V> result = ObjectDoubleMaps.mutable.empty();
        ObjectDoubleHashMap<V> groupKeyToCompensation = ObjectDoubleHashMap.newMap();
        for (int i = 0; i < size2; ++i) {
            T item = array[i];
            V groupByKey = groupBy.valueOf(item);
            double compensation = groupKeyToCompensation.getIfAbsentPut(groupByKey, 0.0);
            double adjustedValue = function.doubleValueOf(item) - compensation;
            double nextSum = result.get(groupByKey) + adjustedValue;
            groupKeyToCompensation.put(groupByKey, nextSum - result.get(groupByKey) - adjustedValue);
            result.put(groupByKey, nextSum);
        }
        return result;
    }

    public static <T> IntSummaryStatistics summarizeInt(T[] items, int size2, IntFunction<? super T> function) {
        IntSummaryStatistics stats = new IntSummaryStatistics();
        for (int i = 0; i < size2; ++i) {
            T item = items[i];
            stats.accept(function.intValueOf(item));
        }
        return stats;
    }

    public static <T> DoubleSummaryStatistics summarizeFloat(T[] items, int size2, FloatFunction<? super T> function) {
        DoubleSummaryStatistics stats = new DoubleSummaryStatistics();
        for (int i = 0; i < size2; ++i) {
            T item = items[i];
            stats.accept(function.floatValueOf(item));
        }
        return stats;
    }

    public static <T> LongSummaryStatistics summarizeLong(T[] items, int size2, LongFunction<? super T> function) {
        LongSummaryStatistics stats = new LongSummaryStatistics();
        for (int i = 0; i < size2; ++i) {
            T item = items[i];
            stats.accept(function.longValueOf(item));
        }
        return stats;
    }

    public static <T> DoubleSummaryStatistics summarizeDouble(T[] items, int size2, DoubleFunction<? super T> function) {
        DoubleSummaryStatistics stats = new DoubleSummaryStatistics();
        for (int i = 0; i < size2; ++i) {
            T item = items[i];
            stats.accept(function.doubleValueOf(item));
        }
        return stats;
    }

    public static <T> Optional<T> reduce(T[] items, int size2, BinaryOperator<T> accumulator) {
        if (size2 == 0) {
            return Optional.empty();
        }
        Object result = items[0];
        for (int i = 1; i < size2; ++i) {
            result = accumulator.apply(result, items[i]);
        }
        return Optional.of(result);
    }

    public static <R, A, T> R reduceInPlace(T[] items, int size2, Collector<? super T, A, R> collector) {
        A mutableResult = collector.supplier().get();
        BiConsumer<A, A> accumulator = collector.accumulator();
        for (int i = 0; i < size2; ++i) {
            T item = items[i];
            accumulator.accept(mutableResult, item);
        }
        return collector.finisher().apply(mutableResult);
    }

    public static <R, T> R reduceInPlace(T[] items, int size2, Supplier<R> supplier, BiConsumer<R, ? super T> accumulator) {
        R mutableResult = supplier.get();
        for (int i = 0; i < size2; ++i) {
            T item = items[i];
            accumulator.accept(mutableResult, item);
        }
        return mutableResult;
    }
}

