/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableIntStack;
import org.eclipse.collections.api.stack.primitive.IntStack;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.IntStacks;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.stack.mutable.primitive.IntArrayStack;

final class ImmutableIntSingletonStack
implements ImmutableIntStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int element1;

    ImmutableIntSingletonStack(int element) {
        this.element1 = element;
    }

    @Override
    public IntIterator intIterator() {
        return new UnmodifiableIntIterator(IntArrayStack.newStackWith(this.element1).intIterator());
    }

    @Override
    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(IntProcedure procedure) {
        procedure.value(this.element1);
    }

    @Override
    public int count(IntPredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        return predicate.accept(this.element1);
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        return predicate.accept(this.element1);
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        return !predicate.accept(this.element1);
    }

    @Override
    public int peek() {
        return this.element1;
    }

    @Override
    public IntList peek(int count2) {
        this.checkNegativeCount(count2);
        if (count2 == 0) {
            return new IntArrayList(0);
        }
        if (count2 == 1) {
            return IntArrayList.newListWith(this.element1);
        }
        throw new IllegalArgumentException("Count must be less than or equal to size: Count = " + count2 + " Size = 1");
    }

    @Override
    public int peekAt(int index) {
        this.checkNegativeCount(index);
        if (index == 0) {
            return this.element1;
        }
        throw new IllegalArgumentException("Index must be less than size: Index = " + index + " Size = 1");
    }

    @Override
    public ImmutableIntStack select(IntPredicate predicate) {
        return predicate.accept(this.element1) ? IntStacks.immutable.with(this.element1) : IntStacks.immutable.with();
    }

    @Override
    public ImmutableIntStack reject(IntPredicate predicate) {
        return predicate.accept(this.element1) ? IntStacks.immutable.with() : IntStacks.immutable.with(this.element1);
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    @Override
    public <V> ImmutableStack<V> collect(IntToObjectFunction<? extends V> function) {
        return Stacks.immutable.with(function.valueOf(this.element1));
    }

    @Override
    public long sum() {
        return this.element1;
    }

    @Override
    public int max() {
        return this.element1;
    }

    @Override
    public int maxIfEmpty(int defaultValue) {
        return this.element1;
    }

    @Override
    public int min() {
        return this.element1;
    }

    @Override
    public int minIfEmpty(int defaultValue) {
        return this.element1;
    }

    @Override
    public double average() {
        return this.element1;
    }

    @Override
    public double median() {
        return this.element1;
    }

    @Override
    public int[] toSortedArray() {
        return new int[]{this.element1};
    }

    @Override
    public MutableIntList toSortedList() {
        return IntArrayList.newListWith(this.element1);
    }

    @Override
    public int[] toArray() {
        return new int[]{this.element1};
    }

    @Override
    public boolean contains(int value) {
        return this.element1 == value;
    }

    @Override
    public boolean containsAll(int ... source) {
        for (int value : source) {
            if (this.element1 == value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(IntIterable source) {
        IntIterator iterator2 = source.intIterator();
        while (iterator2.hasNext()) {
            if (this.element1 == iterator2.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableIntList toList() {
        return IntArrayList.newListWith(this.element1);
    }

    @Override
    public MutableIntSet toSet() {
        return IntHashSet.newSetWith(this.element1);
    }

    @Override
    public MutableIntBag toBag() {
        return IntHashBag.newBagWith(this.element1);
    }

    @Override
    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter(this);
    }

    @Override
    public ImmutableIntStack toImmutable() {
        return this;
    }

    @Override
    public ImmutableIntStack push(int element) {
        return IntStacks.immutable.with(this.element1, element);
    }

    @Override
    public ImmutableIntStack pop() {
        return IntStacks.immutable.with();
    }

    @Override
    public ImmutableIntStack pop(int count2) {
        this.checkNegativeCount(count2);
        if (count2 == 0) {
            return this;
        }
        if (count2 == 1) {
            return IntStacks.immutable.with();
        }
        throw new IllegalArgumentException("Count must be less than size: Count = " + count2 + " Size = 1");
    }

    private void checkNegativeCount(int count2) {
        if (count2 < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count2);
        }
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.element1);
    }

    @Override
    public RichIterable<IntIterable> chunk(int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        return Lists.immutable.with(this);
    }

    @Override
    public int getFirst() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getFirst() not implemented yet");
    }

    @Override
    public int indexOf(int value) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".indexOf() not implemented yet");
    }

    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectIntIntToObjectFunction<? super T, ? extends T> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".injectIntoWithIndex() not implemented yet");
    }

    @Override
    public void forEachWithIndex(IntIntProcedure procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEachWithIndex() not implemented yet");
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof IntStack)) {
            return false;
        }
        IntStack stack = (IntStack)otherStack;
        if (stack.size() != 1) {
            return false;
        }
        return this.element1 == stack.peek();
    }

    @Override
    public int hashCode() {
        return 31 + this.element1;
    }

    @Override
    public String toString() {
        return "[" + this.element1 + ']';
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

