/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;

public class SynchronizedFloatIterable
implements FloatIterable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    private final FloatIterable iterable;

    protected SynchronizedFloatIterable(FloatIterable iterable) {
        this(iterable, null);
    }

    protected SynchronizedFloatIterable(FloatIterable iterable, Object newLock) {
        if (iterable == null) {
            throw new IllegalArgumentException("Cannot create a SynchronizedFloatIterable on a null collection");
        }
        this.iterable = iterable;
        this.lock = newLock == null ? this : newLock;
    }

    public static SynchronizedFloatIterable of(FloatIterable iterable) {
        return new SynchronizedFloatIterable(iterable);
    }

    public static SynchronizedFloatIterable of(FloatIterable iterable, Object lock) {
        return new SynchronizedFloatIterable(iterable, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(float value) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(float ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(FloatIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.containsAll(source);
        }
    }

    @Override
    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void each(FloatProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.iterable.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FloatIterable select(FloatPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FloatIterable reject(FloatPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> RichIterable<V> collect(FloatToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.detectIfNone(predicate, ifNone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(FloatPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean noneSatisfy(FloatPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatList toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatSet toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatBag toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyFloatIterable asLazy() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.asLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double sum() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float max() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.max();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float maxIfEmpty(float defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.maxIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float min() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.min();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float minIfEmpty(float defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.minIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double average() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.average();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double median() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.median();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] toSortedArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toSortedArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatList toSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RichIterable<FloatIterable> chunk(int size2) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.chunk(size2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.iterable.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.iterable.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.iterable.appendString(appendable, start, separator, end);
        }
    }

    @Override
    public FloatIterator floatIterator() {
        return this.iterable.floatIterator();
    }
}

