/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongBooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongBooleanProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.map.primitive.ImmutableLongBooleanMap;
import org.eclipse.collections.api.map.primitive.LongBooleanMap;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.LongBooleanPair;
import org.eclipse.collections.impl.bag.mutable.primitive.BooleanHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.BooleanBags;
import org.eclipse.collections.impl.factory.primitive.LongBooleanMaps;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.iterator.UnmodifiableBooleanIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.LongBooleanHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.BooleanHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableLongBooleanSingletonMap
implements ImmutableLongBooleanMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean EMPTY_VALUE = false;
    private final long key1;
    private final boolean value1;

    ImmutableLongBooleanSingletonMap(long key1, boolean value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    @Override
    public boolean get(long key) {
        return this.getIfAbsent(key, false);
    }

    @Override
    public boolean getIfAbsent(long key, boolean ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    @Override
    public boolean getOrThrow(long key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(long key) {
        return this.key1 == key;
    }

    @Override
    public boolean containsValue(boolean value) {
        return this.value1 == value;
    }

    @Override
    public void forEachValue(BooleanProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public void forEachKey(LongProcedure procedure) {
        procedure.value(this.key1);
    }

    @Override
    public void forEachKeyValue(LongBooleanProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    @Override
    public LazyLongIterable keysView() {
        return LongLists.immutable.of(this.key1).asLazy();
    }

    @Override
    public RichIterable<LongBooleanPair> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    @Override
    public ImmutableLongBooleanMap select(LongBooleanPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? LongBooleanHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new LongBooleanHashMap().toImmutable();
    }

    @Override
    public ImmutableLongBooleanMap reject(LongBooleanPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new LongBooleanHashMap().toImmutable() : LongBooleanHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.value1);
    }

    @Override
    public RichIterable<BooleanIterable> chunk(int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        return Lists.mutable.with(BooleanBags.immutable.with(this.value1));
    }

    @Override
    public ImmutableLongBooleanMap toImmutable() {
        return this;
    }

    @Override
    public BooleanIterator booleanIterator() {
        return new UnmodifiableBooleanIterator(LongBooleanHashMap.newWithKeysValues(this.key1, this.value1).booleanIterator());
    }

    @Override
    public void forEach(BooleanProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(BooleanProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public int count(BooleanPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    @Override
    public ImmutableBooleanBag select(BooleanPredicate predicate) {
        return predicate.accept(this.value1) ? BooleanHashBag.newBagWith(this.value1).toImmutable() : BooleanBags.immutable.empty();
    }

    @Override
    public ImmutableBooleanBag reject(BooleanPredicate predicate) {
        return predicate.accept(this.value1) ? BooleanBags.immutable.empty() : BooleanHashBag.newBagWith(this.value1).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> collect(BooleanToObjectFunction<? extends V> function) {
        return Bags.immutable.of(function.valueOf(this.value1));
    }

    @Override
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    @Override
    public boolean[] toArray() {
        return new boolean[]{this.value1};
    }

    @Override
    public boolean contains(boolean value) {
        return this.value1 == value;
    }

    @Override
    public boolean containsAll(boolean ... source) {
        for (boolean value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(BooleanIterable source) {
        BooleanIterator iterator2 = source.booleanIterator();
        while (iterator2.hasNext()) {
            if (this.value1 == iterator2.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableBooleanList toList() {
        return BooleanArrayList.newListWith(this.value1);
    }

    @Override
    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSetWith(this.value1);
    }

    @Override
    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBagWith(this.value1);
    }

    @Override
    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter(this);
    }

    @Override
    public ImmutableLongBooleanMap newWithKeyValue(long key, boolean value) {
        return LongBooleanMaps.immutable.withAll(LongBooleanHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    @Override
    public ImmutableLongBooleanMap newWithoutKey(long key) {
        return this.key1 == key ? LongBooleanMaps.immutable.with() : this;
    }

    @Override
    public ImmutableLongBooleanMap newWithoutAllKeys(LongIterable keys2) {
        return keys2.contains(this.key1) ? LongBooleanMaps.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public MutableLongSet keySet() {
        return UnmodifiableLongSet.of(LongHashSet.newSetWith(this.key1));
    }

    @Override
    public MutableBooleanCollection values() {
        return UnmodifiableBooleanCollection.of(BooleanArrayList.newListWith(this.value1));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LongBooleanMap)) {
            return false;
        }
        LongBooleanMap map2 = (LongBooleanMap)obj;
        if (map2.size() != 1) {
            return false;
        }
        return map2.containsKey(this.key1) && this.value1 == map2.getOrThrow(this.key1);
    }

    @Override
    public int hashCode() {
        return (int)(this.key1 ^ this.key1 >>> 32) ^ (this.value1 ? 1231 : 1237);
    }

    @Override
    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

