/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableShortBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntShortPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntShortProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.map.primitive.ImmutableIntShortMap;
import org.eclipse.collections.api.map.primitive.ImmutableShortIntMap;
import org.eclipse.collections.api.map.primitive.IntShortMap;
import org.eclipse.collections.api.map.primitive.MutableIntShortMap;
import org.eclipse.collections.api.map.primitive.MutableShortIntMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.IntShortPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedIntShortProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ShortBags;
import org.eclipse.collections.impl.factory.primitive.ShortIntMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableShortIterator;
import org.eclipse.collections.impl.map.mutable.primitive.IntShortHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableIntSet;

final class ImmutableIntShortHashMap
implements ImmutableIntShortMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableIntShortMap delegate;

    ImmutableIntShortHashMap(IntShortMap delegate) {
        this.delegate = new IntShortHashMap(delegate);
    }

    @Override
    public short get(int key) {
        return this.delegate.get(key);
    }

    @Override
    public short getIfAbsent(int key, short ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public short getOrThrow(int key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public boolean containsKey(int key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(short value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(ShortProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(IntProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(IntShortProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    @Override
    public LazyIntIterable keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<IntShortPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public ImmutableShortIntMap flipUniqueValues() {
        MutableShortIntMap result = ShortIntMaps.mutable.empty();
        this.forEachKeyValue((key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result.toImmutable();
    }

    @Override
    public ImmutableIntShortMap select(IntShortPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableIntShortMap reject(IntShortPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public RichIterable<ShortIterable> chunk(int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            ShortIterator iterator2 = this.delegate.shortIterator();
            while (iterator2.hasNext()) {
                MutableShortBag batch = ShortBags.mutable.empty();
                for (int i = 0; i < size2 && iterator2.hasNext(); ++i) {
                    batch.add(iterator2.next());
                }
                result.add(batch.toImmutable());
            }
        }
        return result.toImmutable();
    }

    @Override
    public ImmutableIntShortMap toImmutable() {
        return this;
    }

    @Override
    public ShortIterator shortIterator() {
        return new UnmodifiableShortIterator(this.delegate.shortIterator());
    }

    @Override
    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ShortProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(ShortPredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(ShortPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableShortBag select(ShortPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableShortBag reject(ShortPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> collect(ShortToObjectFunction<? extends V> function) {
        RichIterable bag = this.delegate.collect((ShortToObjectFunction)function);
        return bag.toImmutable();
    }

    @Override
    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public short max() {
        return this.delegate.max();
    }

    @Override
    public short maxIfEmpty(short defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public short min() {
        return this.delegate.min();
    }

    @Override
    public short minIfEmpty(short defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public short[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableShortList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public short[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public boolean contains(short value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(short ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(ShortIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableShortList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableShortSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableShortBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyShortIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableIntShortMap newWithKeyValue(int key, short value) {
        IntShortHashMap map2 = new IntShortHashMap(this.size() + 1);
        map2.putAll(this);
        map2.put(key, value);
        return map2.toImmutable();
    }

    @Override
    public ImmutableIntShortMap newWithoutKey(int key) {
        IntShortHashMap map2 = new IntShortHashMap(this.size());
        map2.putAll(this);
        map2.removeKey(key);
        return map2.toImmutable();
    }

    @Override
    public ImmutableIntShortMap newWithoutAllKeys(IntIterable keys2) {
        IntShortHashMap map2 = new IntShortHashMap(this.size());
        map2.putAll(this);
        IntIterator iterator2 = keys2.intIterator();
        while (iterator2.hasNext()) {
            map2.removeKey(iterator2.next());
        }
        return map2.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableIntSet keySet() {
        return UnmodifiableIntSet.of(this.delegate.keySet());
    }

    @Override
    public MutableShortCollection values() {
        return UnmodifiableShortCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableIntShortMapSerializationProxy(this);
    }

    protected static class ImmutableIntShortMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private IntShortMap map;

        public ImmutableIntShortMapSerializationProxy() {
        }

        protected ImmutableIntShortMapSerializationProxy(IntShortMap map2) {
            this.map = map2;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue(new CheckedIntShortProcedure(){

                    @Override
                    public void safeValue(int key, short value) throws IOException {
                        out.writeInt(key);
                        out.writeShort(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size2 = in.readInt();
            IntShortHashMap deserializedMap = new IntShortHashMap();
            for (int i = 0; i < size2; ++i) {
                deserializedMap.put(in.readInt(), in.readShort());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

