/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.ImmutableIntIntMap;
import org.eclipse.collections.api.map.primitive.IntIntMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.IntIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.IntBags;
import org.eclipse.collections.impl.factory.primitive.IntIntMaps;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.IntIntHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableIntIntSingletonMap
implements ImmutableIntIntMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_VALUE = 0;
    private final int key1;
    private final int value1;

    ImmutableIntIntSingletonMap(int key1, int value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    @Override
    public int get(int key) {
        return this.getIfAbsent(key, 0);
    }

    @Override
    public int getIfAbsent(int key, int ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    @Override
    public int getOrThrow(int key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(int key) {
        return this.key1 == key;
    }

    @Override
    public boolean containsValue(int value) {
        return this.value1 == value;
    }

    @Override
    public void forEachValue(IntProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public void forEachKey(IntProcedure procedure) {
        procedure.value(this.key1);
    }

    @Override
    public void forEachKeyValue(IntIntProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    @Override
    public LazyIntIterable keysView() {
        return IntLists.immutable.of(this.key1).asLazy();
    }

    @Override
    public RichIterable<IntIntPair> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    @Override
    public ImmutableIntIntMap flipUniqueValues() {
        return IntIntMaps.immutable.with(this.value1, this.key1);
    }

    @Override
    public ImmutableIntIntMap select(IntIntPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? IntIntHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new IntIntHashMap().toImmutable();
    }

    @Override
    public ImmutableIntIntMap reject(IntIntPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new IntIntHashMap().toImmutable() : IntIntHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.value1);
    }

    @Override
    public RichIterable<IntIterable> chunk(int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        return Lists.mutable.with(IntBags.immutable.with(this.value1));
    }

    @Override
    public ImmutableIntIntMap toImmutable() {
        return this;
    }

    @Override
    public IntIterator intIterator() {
        return new UnmodifiableIntIterator(IntIntHashMap.newWithKeysValues(this.key1, this.value1).intIterator());
    }

    @Override
    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(IntProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public int count(IntPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    @Override
    public long sum() {
        return this.value1;
    }

    @Override
    public int min() {
        return this.value1;
    }

    @Override
    public int max() {
        return this.value1;
    }

    @Override
    public int maxIfEmpty(int defaultValue) {
        return this.value1;
    }

    @Override
    public int minIfEmpty(int defaultValue) {
        return this.value1;
    }

    @Override
    public double average() {
        return this.value1;
    }

    @Override
    public double median() {
        return this.value1;
    }

    @Override
    public int[] toSortedArray() {
        return new int[]{this.value1};
    }

    @Override
    public MutableIntList toSortedList() {
        return IntArrayList.newListWith(this.value1);
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    @Override
    public ImmutableIntBag select(IntPredicate predicate) {
        return predicate.accept(this.value1) ? IntHashBag.newBagWith(this.value1).toImmutable() : IntBags.immutable.empty();
    }

    @Override
    public ImmutableIntBag reject(IntPredicate predicate) {
        return predicate.accept(this.value1) ? IntBags.immutable.empty() : IntHashBag.newBagWith(this.value1).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> collect(IntToObjectFunction<? extends V> function) {
        return Bags.immutable.of(function.valueOf(this.value1));
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    @Override
    public int[] toArray() {
        return new int[]{this.value1};
    }

    @Override
    public boolean contains(int value) {
        return this.value1 == value;
    }

    @Override
    public boolean containsAll(int ... source) {
        for (int value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(IntIterable source) {
        IntIterator iterator2 = source.intIterator();
        while (iterator2.hasNext()) {
            if (this.value1 == iterator2.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableIntList toList() {
        return IntArrayList.newListWith(this.value1);
    }

    @Override
    public MutableIntSet toSet() {
        return IntHashSet.newSetWith(this.value1);
    }

    @Override
    public MutableIntBag toBag() {
        return IntHashBag.newBagWith(this.value1);
    }

    @Override
    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter(this);
    }

    @Override
    public ImmutableIntIntMap newWithKeyValue(int key, int value) {
        return IntIntMaps.immutable.withAll(IntIntHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    @Override
    public ImmutableIntIntMap newWithoutKey(int key) {
        return this.key1 == key ? IntIntMaps.immutable.with() : this;
    }

    @Override
    public ImmutableIntIntMap newWithoutAllKeys(IntIterable keys2) {
        return keys2.contains(this.key1) ? IntIntMaps.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public MutableIntSet keySet() {
        return UnmodifiableIntSet.of(IntHashSet.newSetWith(this.key1));
    }

    @Override
    public MutableIntCollection values() {
        return UnmodifiableIntCollection.of(IntArrayList.newListWith(this.value1));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntIntMap)) {
            return false;
        }
        IntIntMap map2 = (IntIntMap)obj;
        if (map2.size() != 1) {
            return false;
        }
        return map2.containsKey(this.key1) && this.value1 == map2.getOrThrow(this.key1);
    }

    @Override
    public int hashCode() {
        return this.key1 ^ this.value1;
    }

    @Override
    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

