/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.impl.block.procedure.checked.CheckedProcedure2;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;

class ImmutableMapSerializationProxy<K, V>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ImmutableMap<K, V> map;

    public ImmutableMapSerializationProxy() {
    }

    ImmutableMapSerializationProxy(ImmutableMap<K, V> map2) {
        this.map = map2;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.map.size());
        try {
            this.map.forEachKeyValue(new CheckedProcedure2<K, V>(){

                @Override
                public void safeValue(K key, V value) throws IOException {
                    out.writeObject(key);
                    out.writeObject(value);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        UnifiedMap<Object, Object> deserializedMap = UnifiedMap.newMap(size2);
        for (int i = 0; i < size2; ++i) {
            if (deserializedMap.put(in.readObject(), in.readObject()) == null) continue;
            throw new IllegalStateException();
        }
        this.map = deserializedMap.toImmutable();
    }

    protected Object readResolve() {
        return this.map;
    }
}

