/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyBooleanIterable;

public class TapBooleanIterable
extends AbstractLazyBooleanIterable {
    private final BooleanIterable adapted;
    private final BooleanProcedure procedure;

    public TapBooleanIterable(BooleanIterable delegate, BooleanProcedure procedure) {
        this.adapted = delegate;
        this.procedure = procedure;
    }

    @Override
    public void each(BooleanProcedure procedure) {
        this.adapted.forEach(each2 -> {
            this.procedure.value(each2);
            procedure.value(each2);
        });
    }

    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        return this.adapted.anySatisfy(each2 -> {
            this.procedure.value(each2);
            return predicate.accept(each2);
        });
    }

    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        return this.adapted.allSatisfy(each2 -> {
            this.procedure.value(each2);
            return predicate.accept(each2);
        });
    }

    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        return this.adapted.noneSatisfy(each2 -> {
            this.procedure.value(each2);
            return predicate.accept(each2);
        });
    }

    @Override
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return this.adapted.detectIfNone(each2 -> {
            this.procedure.value(each2);
            return predicate.accept(each2);
        }, ifNone);
    }

    @Override
    public BooleanIterator booleanIterator() {
        return new TapBooleanIterator(this.adapted, this.procedure);
    }

    public static class TapBooleanIterator
    implements BooleanIterator {
        private final BooleanIterator iterator;
        private final BooleanProcedure procedure;

        public TapBooleanIterator(BooleanIterable iterable, BooleanProcedure procedure) {
            this(iterable.booleanIterator(), procedure);
        }

        public TapBooleanIterator(BooleanIterator iterator2, BooleanProcedure procedure) {
            this.iterator = iterator2;
            this.procedure = procedure;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public boolean next() {
            boolean next = this.iterator.next();
            this.procedure.value(next);
            return next;
        }
    }
}

