/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel.bag;

import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.ParallelUnsortedBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.multimap.bag.UnsortedBagMultimap;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.BagAddOccurrencesProcedure;
import org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterable;
import org.eclipse.collections.impl.lazy.parallel.bag.ParallelCollectUnsortedBag;
import org.eclipse.collections.impl.lazy.parallel.bag.ParallelSelectUnsortedBag;
import org.eclipse.collections.impl.lazy.parallel.bag.UnsortedBagBatch;
import org.eclipse.collections.impl.multimap.bag.SynchronizedPutHashBagMultimap;

@Beta
public abstract class AbstractParallelUnsortedBag<T, B extends UnsortedBagBatch<T>>
extends AbstractParallelIterable<T, B>
implements ParallelUnsortedBag<T> {
    @Override
    protected boolean isOrdered() {
        return false;
    }

    @Override
    public ParallelUnsortedSetIterable<T> asUnique() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".asUnique() not implemented yet");
    }

    @Override
    public ParallelUnsortedBag<T> select(Predicate<? super T> predicate) {
        return new ParallelSelectUnsortedBag<T>(this, predicate);
    }

    @Override
    public <P> ParallelUnsortedBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.select((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public <S> ParallelUnsortedBag<S> selectInstancesOf(Class<S> clazz) {
        return this.select(Predicates.instanceOf(clazz));
    }

    @Override
    public ParallelUnsortedBag<T> reject(Predicate<? super T> predicate) {
        return this.select(Predicates.not(predicate));
    }

    @Override
    public <P> ParallelUnsortedBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.reject((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public <V> ParallelUnsortedBag<V> collect(Function<? super T, ? extends V> function) {
        return new ParallelCollectUnsortedBag<T, V>(this, function);
    }

    @Override
    public <P, V> ParallelUnsortedBag<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collect((Function)Functions.bind(function, parameter));
    }

    @Override
    public <V> ParallelUnsortedBag<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.select((Predicate)predicate).collect((Function)function);
    }

    @Override
    public <V> ParallelUnsortedBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".flatCollect() not implemented yet");
    }

    @Override
    public MutableBag<T> toBag() {
        MutableCollection result = HashBag.newBag().asSynchronized();
        this.forEachWithOccurrences(BagAddOccurrencesProcedure.on(result));
        return result;
    }

    @Override
    public <V> UnsortedBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        SynchronizedPutHashBagMultimap result = SynchronizedPutHashBagMultimap.newMultimap();
        this.forEachWithOccurrences((each2, occurrences) -> {
            Object key = function.valueOf(each2);
            for (int i = 0; i < occurrences; ++i) {
                result.put(key, each2);
            }
        });
        return result;
    }

    @Override
    public <V> UnsortedBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        SynchronizedPutHashBagMultimap result = SynchronizedPutHashBagMultimap.newMultimap();
        this.forEachWithOccurrences((each2, occurrences) -> {
            Iterable keys2 = (Iterable)function.valueOf(each2);
            for (Object key : keys2) {
                for (int i = 0; i < occurrences; ++i) {
                    result.put(key, each2);
                }
            }
        });
        return result;
    }
}

