/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy;

import java.util.Iterator;
import java.util.Optional;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.iterator.TapIterator;
import org.eclipse.collections.impl.utility.Iterate;

public class TapIterable<T>
extends AbstractLazyIterable<T> {
    private final Iterable<T> adapted;
    private final Procedure<? super T> procedure;

    public TapIterable(Iterable<T> newAdapted, Procedure<? super T> procedure) {
        this.adapted = newAdapted;
        this.procedure = procedure;
    }

    @Override
    public void each(Procedure<? super T> procedure) {
        Iterate.forEach(this.adapted, each2 -> {
            this.procedure.value(each2);
            procedure.value(each2);
        });
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        Iterate.forEachWithIndex(this.adapted, (each2, index) -> {
            this.procedure.value(each2);
            objectIntProcedure.value(each2, index);
        });
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        Iterate.forEachWith(this.adapted, (each2, aParameter) -> {
            this.procedure.value(each2);
            procedure.value((T)each2, (Object)aParameter);
        }, parameter);
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return Iterate.anySatisfy(this.adapted, each2 -> {
            this.procedure.value(each2);
            return predicate.accept(each2);
        });
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return Iterate.allSatisfy(this.adapted, each2 -> {
            this.procedure.value(each2);
            return predicate.accept(each2);
        });
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        return Iterate.noneSatisfy(this.adapted, each2 -> {
            this.procedure.value(each2);
            return predicate.accept(each2);
        });
    }

    @Override
    public T getFirst() {
        return (T)Iterate.detect(this.adapted, each2 -> {
            this.procedure.value(each2);
            return true;
        });
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return (T)Iterate.detect(this.adapted, each2 -> {
            this.procedure.value(each2);
            return predicate.accept(each2);
        });
    }

    @Override
    public Optional<T> detectOptional(Predicate<? super T> predicate) {
        return Iterate.detectOptional(this.adapted, each2 -> {
            this.procedure.value(each2);
            return predicate.accept(each2);
        });
    }

    @Override
    public Iterator<T> iterator() {
        return new TapIterator<T>(this.adapted, this.procedure);
    }
}

