/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.factory;

import org.eclipse.collections.impl.block.factory.Predicates2;
import org.eclipse.collections.impl.utility.StringIterate;

public final class StringPredicates2 {
    private static final ContainsString CONTAINS_STRING = new ContainsString();
    private static final NotContainsString NOT_CONTAINS_STRING = new NotContainsString();
    private static final StartsWith STARTS_WITH = new StartsWith();
    private static final NotStartsWith NOT_STARTS_WITH = new NotStartsWith();
    private static final EndsWith ENDS_WITH = new EndsWith();
    private static final NotEndsWith NOT_ENDS_WITH = new NotEndsWith();
    private static final EqualsIgnoreCase EQUALS_IGNORE_CASE = new EqualsIgnoreCase();
    private static final NotEqualsIgnoreCase NOT_EQUALS_IGNORE_CASE = new NotEqualsIgnoreCase();
    private static final MatchesRegex MATCHES_REGEX = new MatchesRegex();

    private StringPredicates2() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static Predicates2<String, String> contains() {
        return CONTAINS_STRING;
    }

    public static Predicates2<String, String> notContains() {
        return NOT_CONTAINS_STRING;
    }

    public static Predicates2<String, String> startsWith() {
        return STARTS_WITH;
    }

    public static Predicates2<String, String> notStartsWith() {
        return NOT_STARTS_WITH;
    }

    public static Predicates2<String, String> endsWith() {
        return ENDS_WITH;
    }

    public static Predicates2<String, String> notEndsWith() {
        return NOT_ENDS_WITH;
    }

    public static Predicates2<String, String> equalsIgnoreCase() {
        return EQUALS_IGNORE_CASE;
    }

    public static Predicates2<String, String> notEqualsIgnoreCase() {
        return NOT_EQUALS_IGNORE_CASE;
    }

    public static Predicates2<String, String> matches() {
        return MATCHES_REGEX;
    }

    private static final class MatchesRegex
    extends Predicates2<String, String> {
        private static final long serialVersionUID = 1L;

        private MatchesRegex() {
        }

        @Override
        public boolean accept(String each2, String parameter) {
            return each2 != null && each2.matches(parameter);
        }

        public String toString() {
            return "StringPredicates2.matches()";
        }
    }

    private static final class NotEqualsIgnoreCase
    extends Predicates2<String, String> {
        private static final long serialVersionUID = 1L;

        private NotEqualsIgnoreCase() {
        }

        @Override
        public boolean accept(String each2, String parameter) {
            return each2 == null || !each2.equalsIgnoreCase(parameter);
        }

        public String toString() {
            return "StringPredicates2.notEqualsIgnoreCase()";
        }
    }

    private static final class EqualsIgnoreCase
    extends Predicates2<String, String> {
        private static final long serialVersionUID = 1L;

        private EqualsIgnoreCase() {
        }

        @Override
        public boolean accept(String each2, String parameter) {
            return each2 != null && each2.equalsIgnoreCase(parameter);
        }

        public String toString() {
            return "StringPredicates2.equalsIgnoreCase()";
        }
    }

    private static final class NotEndsWith
    extends Predicates2<String, String> {
        private static final long serialVersionUID = 1L;

        private NotEndsWith() {
        }

        @Override
        public boolean accept(String each2, String parameter) {
            return each2 == null || !each2.endsWith(parameter);
        }

        public String toString() {
            return "StringPredicates2.notEndsWith()";
        }
    }

    private static final class EndsWith
    extends Predicates2<String, String> {
        private static final long serialVersionUID = 1L;

        private EndsWith() {
        }

        @Override
        public boolean accept(String each2, String parameter) {
            return each2 != null && each2.endsWith(parameter);
        }

        public String toString() {
            return "StringPredicates2.endsWith()";
        }
    }

    private static final class NotStartsWith
    extends Predicates2<String, String> {
        private static final long serialVersionUID = 1L;

        private NotStartsWith() {
        }

        @Override
        public boolean accept(String each2, String parameter) {
            return each2 == null || !each2.startsWith(parameter);
        }

        public String toString() {
            return "StringPredicates2.notStartsWith()";
        }
    }

    private static final class StartsWith
    extends Predicates2<String, String> {
        private static final long serialVersionUID = 1L;

        private StartsWith() {
        }

        @Override
        public boolean accept(String each2, String parameter) {
            return each2 != null && each2.startsWith(parameter);
        }

        public String toString() {
            return "StringPredicates2.startsWith()";
        }
    }

    private static final class NotContainsString
    extends Predicates2<String, String> {
        private static final long serialVersionUID = 1L;

        private NotContainsString() {
        }

        @Override
        public boolean accept(String each2, String parameter) {
            return StringIterate.isEmpty(each2) || !each2.contains(parameter);
        }

        public String toString() {
            return "StringPredicates2.notContains()";
        }
    }

    private static final class ContainsString
    extends Predicates2<String, String> {
        private static final long serialVersionUID = 1L;

        private ContainsString() {
        }

        @Override
        public boolean accept(String each2, String parameter) {
            return StringIterate.notEmpty(each2) && each2.contains(parameter);
        }

        public String toString() {
            return "StringPredicates2.contains()";
        }
    }
}

