/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.listener;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChainedTransferListener
extends AbstractTransferListener {
    private final List<TransferListener> listeners = new CopyOnWriteArrayList<TransferListener>();

    public static TransferListener newInstance(TransferListener listener1, TransferListener listener2) {
        if (listener1 == null) {
            return listener2;
        }
        if (listener2 == null) {
            return listener1;
        }
        return new ChainedTransferListener(listener1, listener2);
    }

    public ChainedTransferListener(TransferListener ... listeners) {
        if (listeners != null) {
            this.add(Arrays.asList(listeners));
        }
    }

    public ChainedTransferListener(Collection<? extends TransferListener> listeners) {
        this.add(listeners);
    }

    public void add(Collection<? extends TransferListener> listeners) {
        if (listeners != null) {
            for (TransferListener transferListener : listeners) {
                this.add(transferListener);
            }
        }
    }

    public void add(TransferListener listener2) {
        if (listener2 != null) {
            this.listeners.add(listener2);
        }
    }

    public void remove(TransferListener listener2) {
        if (listener2 != null) {
            this.listeners.remove(listener2);
        }
    }

    protected void handleError(TransferEvent event, TransferListener listener2, RuntimeException error) {
    }

    @Override
    public void transferInitiated(TransferEvent event) throws TransferCancelledException {
        for (TransferListener listener2 : this.listeners) {
            try {
                listener2.transferInitiated(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener2, e);
            }
        }
    }

    @Override
    public void transferStarted(TransferEvent event) throws TransferCancelledException {
        for (TransferListener listener2 : this.listeners) {
            try {
                listener2.transferStarted(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener2, e);
            }
        }
    }

    @Override
    public void transferProgressed(TransferEvent event) throws TransferCancelledException {
        for (TransferListener listener2 : this.listeners) {
            try {
                listener2.transferProgressed(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener2, e);
            }
        }
    }

    @Override
    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        for (TransferListener listener2 : this.listeners) {
            try {
                listener2.transferCorrupted(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener2, e);
            }
        }
    }

    @Override
    public void transferSucceeded(TransferEvent event) {
        for (TransferListener listener2 : this.listeners) {
            try {
                listener2.transferSucceeded(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener2, e);
            }
        }
    }

    @Override
    public void transferFailed(TransferEvent event) {
        for (TransferListener listener2 : this.listeners) {
            try {
                listener2.transferFailed(event);
            }
            catch (RuntimeException e) {
                this.handleError(event, listener2, e);
            }
        }
    }
}

