/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.ossindex.version.IVersion;
import net.ossindex.version.IVersionRange;
import net.ossindex.version.impl.AbstractCommonRange;
import net.ossindex.version.impl.BoundedVersionRange;
import net.ossindex.version.impl.VersionImpl;

public class VersionSet
extends AbstractCommonRange
implements Iterable<IVersion> {
    private String type;
    private boolean hasErrors = false;
    private SortedSet<IVersion> set = new TreeSet<IVersion>();

    public VersionSet() {
    }

    public VersionSet(IVersion version) {
        this.set.add(version);
    }

    @Override
    public boolean contains(IVersion version) {
        return this.set.contains(version);
    }

    @Override
    public boolean isDiscrete() {
        return true;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public IVersion getMinimum() {
        if (this.set.isEmpty()) {
            return new VersionImpl(0, 0, 0);
        }
        return this.set.first();
    }

    @Override
    public IVersion getMaximum() {
        if (this.set.isEmpty()) {
            return new VersionImpl(0, 0, 0);
        }
        return this.set.last();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            IVersion version = (IVersion)it.next();
            sb.append(version);
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    public String toMavenString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            IVersion version = (IVersion)it.next();
            sb.append("[" + version + "]");
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public void add(IVersion version) {
        this.set.add(version);
    }

    @Override
    public boolean intersects(IVersionRange yourRange) {
        for (IVersion version : this.set) {
            if (!yourRange.contains(version)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<IVersion> iterator() {
        return this.set.iterator();
    }

    @Override
    public IVersionRange getSimplifiedRange() {
        if (this.set.size() < 5) {
            return this;
        }
        IVersion max2 = null;
        IVersion min2 = null;
        for (IVersion v : this.set) {
            if (max2 == null) {
                max2 = v;
            } else if (v.compareTo(max2) > 0) {
                max2 = v;
            }
            if (min2 == null) {
                min2 = v;
                continue;
            }
            if (v.compareTo(min2) >= 0) continue;
            min2 = v;
        }
        return new BoundedVersionRange(min2, max2);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void setHasErrors(boolean b) {
        this.hasErrors = b;
    }

    @Override
    public boolean hasErrors() {
        return this.hasErrors;
    }

    public Collection<IVersion> getVersions() {
        return this.set;
    }
}

