/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version.impl;

import java.util.Collection;
import net.ossindex.version.IVersion;
import net.ossindex.version.IVersionRange;
import net.ossindex.version.impl.AbstractCommonRange;
import net.ossindex.version.impl.AndRange;
import net.ossindex.version.impl.ExtendedSemanticVersion;
import net.ossindex.version.impl.OrRange;
import net.ossindex.version.impl.SemanticVersion;
import net.ossindex.version.impl.VersionSet;

public class VersionRange
extends AbstractCommonRange {
    private String type;
    private String operator;
    private SemanticVersion version;
    private boolean hasErrors = false;

    public VersionRange(String operator, SemanticVersion version) {
        this.version = version;
        this.operator = operator;
    }

    @Override
    public boolean contains(IVersion version) {
        if (!(version instanceof SemanticVersion)) {
            return false;
        }
        if (this.version instanceof ExtendedSemanticVersion) {
            switch (this.operator) {
                case ">": {
                    return this.version.lessThan(version);
                }
                case ">=": {
                    return this.version.lessThanOrEqualTo(version);
                }
                case "<": {
                    return this.version.greaterThan(version);
                }
                case "<=": {
                    return this.version.greaterThanOrEqualTo(version);
                }
            }
            throw new IllegalArgumentException("Invalid operator: " + this.operator);
        }
        switch (this.operator) {
            case "<": {
                return ((SemanticVersion)version).lessThan(this.version);
            }
            case "<=": {
                return ((SemanticVersion)version).lessThanOrEqualTo(this.version);
            }
            case ">": {
                return ((SemanticVersion)version).greaterThan(this.version);
            }
            case ">=": {
                return ((SemanticVersion)version).greaterThanOrEqualTo(this.version);
            }
        }
        throw new IllegalArgumentException("Invalid operator: " + this.operator);
    }

    @Override
    public boolean isDiscrete() {
        return this.operator == null;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public IVersion getMinimum() {
        switch (this.operator) {
            case "<": 
            case "<=": {
                return new SemanticVersion(0);
            }
            case ">": {
                return this.version;
            }
            case ">=": {
                return this.version;
            }
        }
        throw new IllegalArgumentException("Invalid operator: " + this.operator);
    }

    @Override
    public IVersion getMaximum() {
        switch (this.operator) {
            case "<": {
                return this.version.getPrevVersion();
            }
            case "<=": {
                return this.version;
            }
            case ">": {
                return this.version.getNextVersion();
            }
            case ">=": {
                return null;
            }
        }
        throw new IllegalArgumentException("Invalid operator: " + this.operator);
    }

    public String toString() {
        return this.operator + this.version;
    }

    @Override
    public String toMavenString() {
        String mavenString = "";
        switch (this.operator) {
            case "<=": {
                mavenString = "(,%s]";
                break;
            }
            case "<": {
                mavenString = "(,%s)";
                break;
            }
            case "==": {
                mavenString = "[%s]";
                break;
            }
            case ">=": {
                mavenString = "[%s,)";
                break;
            }
            case ">": {
                mavenString = "(%s,)";
                break;
            }
            default: {
                this.toString();
            }
        }
        return String.format(mavenString, this.version);
    }

    @Override
    public boolean intersects(IVersionRange yourRange) {
        if (yourRange instanceof VersionSet) {
            return yourRange.intersects(this);
        }
        if (yourRange instanceof VersionRange) {
            SemanticVersion useMyVersion = null;
            switch (this.operator) {
                case ">": {
                    useMyVersion = this.version.getNextVersion();
                    break;
                }
                case "<": {
                    useMyVersion = this.version.getPrevVersion();
                    break;
                }
                default: {
                    useMyVersion = this.version;
                }
            }
            if (yourRange.contains(useMyVersion)) {
                return true;
            }
            SemanticVersion useYourVersion = null;
            switch (((VersionRange)yourRange).operator) {
                case ">": {
                    useYourVersion = ((VersionRange)yourRange).version.getNextVersion();
                    break;
                }
                case "<": {
                    useYourVersion = ((VersionRange)yourRange).version.getPrevVersion();
                    break;
                }
                default: {
                    useYourVersion = ((VersionRange)yourRange).version;
                }
            }
            if (this.contains(useYourVersion)) {
                return true;
            }
            return this.version.equals(useYourVersion) && ((VersionRange)yourRange).version.equals(useMyVersion);
        }
        if (yourRange instanceof AndRange) {
            return yourRange.intersects(this);
        }
        if (yourRange instanceof OrRange) {
            return yourRange.intersects(this);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(IVersionRange yourRange) {
        if (yourRange instanceof VersionSet) {
            Collection<IVersion> versions = ((VersionSet)yourRange).getVersions();
            for (IVersion version : versions) {
                if (this.contains(version)) continue;
                return false;
            }
            return true;
        }
        if (yourRange instanceof VersionRange) {
            IVersion myMaximum;
            IVersion minimum = yourRange.getMinimum();
            if (!this.contains(minimum)) {
                return false;
            }
            IVersion maximum = yourRange.getMaximum();
            return !(maximum != null ? !this.contains(maximum) : (myMaximum = this.getMaximum()) != null);
        }
        if (yourRange instanceof AndRange && yourRange.isSimple()) {
            IVersion min2 = yourRange.getMinimum();
            IVersion max2 = yourRange.getMaximum();
            return this.contains(min2) && this.contains(max2);
        }
        return false;
    }

    @Override
    public IVersionRange getSimplifiedRange() {
        return this;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void setHasErrors(boolean b) {
        this.hasErrors = b;
    }

    @Override
    public boolean hasErrors() {
        return this.hasErrors;
    }

    public boolean isUnbounded() {
        switch (this.operator) {
            case ">": 
            case ">=": {
                return true;
            }
        }
        return false;
    }

    @Override
    public IVersionRange invert() {
        switch (this.operator) {
            case ">": {
                return new VersionRange("<=", this.version);
            }
            case ">=": {
                return new VersionRange("<", this.version);
            }
            case "<": {
                return new VersionRange(">=", this.version);
            }
            case "<=": {
                return new VersionRange(">", this.version);
            }
        }
        throw new UnsupportedOperationException();
    }
}

