/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version.impl;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ossindex.version.IVersion;
import net.ossindex.version.IVersionRange;
import net.ossindex.version.InvalidRangeException;
import net.ossindex.version.InvalidRangeRuntimeException;
import net.ossindex.version.impl.AndRange;
import net.ossindex.version.impl.ExtendedSemanticVersion;
import net.ossindex.version.impl.NamedVersion;
import net.ossindex.version.impl.OrRange;
import net.ossindex.version.impl.SemanticVersion;
import net.ossindex.version.impl.VersionRange;
import net.ossindex.version.impl.VersionSet;
import net.ossindex.version.parser.VersionBaseListener;
import net.ossindex.version.parser.VersionParser;

public class VersionListener
extends VersionBaseListener {
    private static final Pattern numericHasLeadingZeroes = Pattern.compile("\\b0+");
    private static final Pattern startsWithDigitLetterOrHyphen = Pattern.compile("^[0-9a-zA-Z\\-]");
    private final boolean strict;
    private Stack<Object> stack = new Stack();
    private IVersionRange range;

    public VersionListener() {
        this.strict = false;
    }

    public VersionListener(boolean strict) {
        this.strict = strict;
    }

    public IVersionRange getRange() {
        return this.range;
    }

    @Override
    public void exitNumeric_version(VersionParser.Numeric_versionContext ctx) {
        SemanticVersion version = null;
        int count2 = ctx.getChildCount();
        switch (count2) {
            case 1: 
            case 2: {
                String token = ctx.getChild(0).getText();
                int major = Integer.parseInt(token);
                version = new SemanticVersion(major);
                break;
            }
            case 3: 
            case 4: {
                int major = Integer.parseInt(ctx.getChild(0).getText());
                int minor = Integer.parseInt(ctx.getChild(2).getText());
                version = new SemanticVersion(major, minor);
                break;
            }
            case 5: 
            case 6: {
                int major = Integer.parseInt(ctx.getChild(0).getText());
                int minor = Integer.parseInt(ctx.getChild(2).getText());
                try {
                    int patch = Integer.parseInt(ctx.getChild(4).getText());
                    version = new SemanticVersion(major, minor, patch);
                }
                catch (NumberFormatException e) {
                    version = new SemanticVersion(major + "." + minor + ".0-" + ctx.getChild(4).getText());
                }
                break;
            }
            case 7: 
            case 8: {
                int major = Integer.parseInt(ctx.getChild(0).getText());
                int minor = Integer.parseInt(ctx.getChild(2).getText());
                int patch = Integer.parseInt(ctx.getChild(4).getText());
                int build = Integer.parseInt(ctx.getChild(6).getText());
                version = new ExtendedSemanticVersion(major, minor, patch, build);
                break;
            }
        }
        this.stack.push(version);
    }

    @Override
    public void exitIdentifier(VersionParser.IdentifierContext ctx) {
        String postfix = ctx.getText();
        Matcher m3 = numericHasLeadingZeroes.matcher(postfix);
        while (m3.find()) {
            postfix = m3.replaceAll("");
        }
        while (!postfix.isEmpty() && !startsWithDigitLetterOrHyphen.matcher(postfix).find()) {
            postfix = postfix.substring(1);
        }
        this.stack.push(postfix);
    }

    @Override
    public void exitPostfix_version(VersionParser.Postfix_versionContext ctx) {
        SemanticVersion version = null;
        int count2 = ctx.getChildCount();
        Object o = this.stack.pop();
        if (!(o instanceof String)) {
            throw new InvalidRangeRuntimeException("Expected string, got " + o.getClass().getSimpleName() + " (" + o + ")");
        }
        String postfix = (String)o;
        block0 : switch (count2) {
            case 4: {
                switch (postfix.toUpperCase()) {
                    case "RELEASE": 
                    case "FINAL": 
                    case "GA": {
                        version = new SemanticVersion(ctx.getChild(0).getText() + "." + ctx.getChild(2).getText());
                        break block0;
                    }
                }
                version = new SemanticVersion(ctx.getChild(0).getText() + "." + ctx.getChild(2).getText() + "." + "0" + "-" + postfix);
                break;
            }
            case 5: {
                version = new SemanticVersion(ctx.getChild(0).getText() + "." + ctx.getChild(2).getText() + "." + "0" + "-" + postfix);
                break;
            }
            case 6: {
                switch (postfix.toUpperCase()) {
                    case "RELEASE": 
                    case "FINAL": 
                    case "GA": {
                        version = new SemanticVersion(ctx.getChild(0).getText() + "." + ctx.getChild(2).getText() + "." + ctx.getChild(4).getText());
                        break block0;
                    }
                }
                version = new SemanticVersion(ctx.getChild(0).getText() + "." + ctx.getChild(2).getText() + "." + ctx.getChild(4).getText() + "-" + postfix);
                break;
            }
            case 7: {
                switch (postfix.toUpperCase()) {
                    case "RELEASE": 
                    case "FINAL": 
                    case "GA": {
                        version = new SemanticVersion(ctx.getChild(0).getText() + "." + ctx.getChild(2).getText() + "." + ctx.getChild(4).getText());
                        break block0;
                    }
                }
                version = new SemanticVersion(ctx.getChild(0).getText() + "." + ctx.getChild(2).getText() + "." + ctx.getChild(4).getText() + "-" + postfix);
                break;
            }
            case 8: 
            case 9: {
                int major = Integer.parseInt(ctx.getChild(0).getText());
                int minor = Integer.parseInt(ctx.getChild(2).getText());
                int patch = Integer.parseInt(ctx.getChild(4).getText());
                int build = Integer.parseInt(ctx.getChild(6).getText());
                version = new ExtendedSemanticVersion(major, minor, patch, build, postfix);
                break;
            }
        }
        this.stack.push(version);
    }

    @Override
    public void exitNamed_version(VersionParser.Named_versionContext ctx) {
        NamedVersion version = null;
        try {
            version = new NamedVersion(ctx.getText());
        }
        catch (InvalidRangeException e) {
            throw new InvalidRangeRuntimeException(e.getMessage(), e);
        }
        this.stack.push(version);
    }

    @Override
    public void exitRange(VersionParser.RangeContext ctx) {
        Object o = this.stack.pop();
        if (o instanceof IVersion) {
            this.range = new VersionSet((IVersion)o);
        } else if (o instanceof IVersionRange) {
            this.range = (IVersionRange)o;
        }
    }

    @Override
    public void exitSimple_range(VersionParser.Simple_rangeContext ctx) {
        String operator = ctx.getChild(0).getText();
        Object o = this.stack.pop();
        if (o instanceof SemanticVersion) {
            switch (operator) {
                case "~>": {
                    SemanticVersion sv = (SemanticVersion)o;
                    VersionRange from = new VersionRange(">=", sv);
                    VersionRange to = new VersionRange("<", sv.getNextParentVersion());
                    this.range = new AndRange(from, to);
                    break;
                }
                default: {
                    this.range = new VersionRange(operator, (SemanticVersion)o);
                }
            }
        } else {
            throw new InvalidRangeRuntimeException("Expected a semantic version, got a " + o.getClass().getSimpleName());
        }
        this.stack.push(this.range);
    }

    @Override
    public void exitVersion_set(VersionParser.Version_setContext ctx) {
        Object o1 = this.stack.pop();
        if (this.stack.isEmpty()) {
            VersionSet set = new VersionSet((IVersion)o1);
            this.stack.push(set);
        } else {
            VersionSet set = (VersionSet)this.stack.peek();
            set.add((IVersion)o1);
        }
    }

    @Override
    public void exitLogical_range(VersionParser.Logical_rangeContext ctx) {
        String first;
        if (ctx.getChildCount() == 2) {
            Object o1 = this.stack.pop();
            Object o2 = this.stack.pop();
            this.stack.push(new AndRange((IVersionRange)o2, (IVersionRange)o1));
        } else if (ctx.getChildCount() == 3 && !"(".equals(first = ctx.getChild(0).getText())) {
            String operator;
            Object o1 = this.stack.pop();
            Object o2 = this.stack.pop();
            switch (operator = ctx.getChild(1).getText()) {
                case "&": 
                case ",": {
                    this.stack.push(new AndRange((IVersionRange)o2, (IVersionRange)o1));
                }
            }
        }
    }

    @Override
    public void exitUnion_range(VersionParser.Union_rangeContext ctx) {
        Object o1 = this.stack.pop();
        Object o2 = this.stack.pop();
        IVersionRange r1 = null;
        IVersionRange r2 = null;
        r1 = o1 instanceof IVersion ? new VersionSet((IVersion)o1) : (IVersionRange)o1;
        r2 = o2 instanceof IVersion ? new VersionSet((IVersion)o2) : (IVersionRange)o2;
        if (r1 instanceof OrRange) {
            this.stack.push(((OrRange)r1).add(r2));
        } else if (r2 instanceof OrRange) {
            this.stack.push(((OrRange)r2).add(r1));
        } else {
            this.stack.push(new OrRange(r2, r1));
        }
    }

    @Override
    public void exitMaven_ranges(VersionParser.Maven_rangesContext ctx) {
        if (ctx.getChildCount() == 3) {
            IVersionRange r1 = (IVersionRange)this.stack.pop();
            IVersionRange r2 = (IVersionRange)this.stack.pop();
            this.stack.push(new OrRange(r2, r1));
        }
    }

    @Override
    public void exitMaven_range(VersionParser.Maven_rangeContext ctx) {
        String text;
        if (ctx.getChildCount() == 3) {
            VersionSet set = new VersionSet();
            if (!"-".equals(ctx.getChild(1).getText())) {
                SemanticVersion v1 = (SemanticVersion)this.stack.pop();
                set.add(v1);
            }
            this.stack.push(set);
            return;
        }
        if (ctx.getChildCount() == 2) {
            VersionSet set = new VersionSet();
            this.stack.push(set);
            return;
        }
        int index = 0;
        String open = ctx.getChild(index).getText();
        SemanticVersion v1 = null;
        SemanticVersion v2 = null;
        if (!",".equals(text = ctx.getChild(++index).getText())) {
            v1 = (SemanticVersion)this.stack.pop();
            ++index;
        }
        String close = null;
        if ("]".equals(text = ctx.getChild(++index).getText()) || ")".equals(text)) {
            close = text;
        } else {
            v2 = (SemanticVersion)this.stack.pop();
            close = ctx.getChild(++index).getText();
        }
        if (v1 != null && v2 != null) {
            SemanticVersion tmp = v1;
            v1 = v2;
            v2 = tmp;
        }
        VersionRange r1 = null;
        if (v1 != null) {
            switch (open) {
                case "(": {
                    r1 = new VersionRange(">", v1);
                    break;
                }
                case "[": {
                    r1 = new VersionRange(">=", v1);
                }
            }
        }
        IVersionRange r2 = null;
        if (v2 != null) {
            switch (close) {
                case ")": {
                    r2 = new VersionRange("<", v2);
                    break;
                }
                case "]": {
                    r2 = new VersionRange("<=", v2);
                }
            }
        }
        if (r1 != null) {
            if (r2 != null) {
                AndRange andRange = new AndRange(r1, r2);
                andRange.setType("maven");
                this.stack.push(andRange);
            } else {
                this.stack.push(r1);
                r1.setType("maven");
            }
        } else {
            this.stack.push(r2);
            r2.setType("maven");
        }
    }

    @Override
    public void exitBroken_range(VersionParser.Broken_rangeContext ctx) {
        if (this.strict) {
            throw new InvalidRangeRuntimeException("Cannot create 'broken' range in strict mode");
        }
    }
}

