/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.sorted.mutable;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.multimap.sortedset.MutableSortedSetMultimap;
import org.eclipse.collections.api.ordered.OrderedIterable;
import org.eclipse.collections.api.partition.set.sorted.PartitionMutableSortedSet;
import org.eclipse.collections.api.set.SetIterable;
import org.eclipse.collections.api.set.sorted.ImmutableSortedSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.set.sorted.ParallelSortedSetIterable;
import org.eclipse.collections.api.set.sorted.SortedSetIterable;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.collection.mutable.AbstractSynchronizedMutableCollection;
import org.eclipse.collections.impl.collection.mutable.SynchronizedCollectionSerializationProxy;
import org.eclipse.collections.impl.factory.SortedSets;
import org.eclipse.collections.impl.lazy.parallel.set.sorted.SynchronizedParallelSortedSetIterable;
import org.eclipse.collections.impl.set.sorted.mutable.SortedSetAdapter;
import org.eclipse.collections.impl.set.sorted.mutable.UnmodifiableSortedSet;
import org.eclipse.collections.impl.stack.mutable.ArrayStack;

public class SynchronizedSortedSet<T>
extends AbstractSynchronizedMutableCollection<T>
implements MutableSortedSet<T>,
Serializable {
    private static final long serialVersionUID = 2L;

    SynchronizedSortedSet(MutableSortedSet<T> set) {
        super(set);
    }

    SynchronizedSortedSet(MutableSortedSet<T> set, Object newLock) {
        super(set, newLock);
    }

    public static <E, S extends SortedSet<E>> SynchronizedSortedSet<E> of(S set) {
        return new SynchronizedSortedSet(SortedSetAdapter.adapt(set));
    }

    public static <E, S extends SortedSet<E>> MutableSortedSet<E> of(S set, Object lock) {
        return new SynchronizedSortedSet(SortedSetAdapter.adapt(set), lock);
    }

    @Override
    protected MutableSortedSet<T> getDelegate() {
        return (MutableSortedSet)super.getDelegate();
    }

    @Override
    public MutableSortedSet<T> with(T element) {
        this.add(element);
        return this;
    }

    @Override
    public MutableSortedSet<T> without(T element) {
        this.remove(element);
        return this;
    }

    @Override
    public MutableSortedSet<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    @Override
    public MutableSortedSet<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().newEmpty().asSynchronized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> clone() {
        Object object = this.getLock();
        synchronized (object) {
            return SynchronizedSortedSet.of(this.getDelegate().clone());
        }
    }

    protected Object writeReplace() {
        return new SynchronizedCollectionSerializationProxy(this.getDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Comparator<? super T> comparator() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().comparator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compareTo(SortedSetIterable<T> o) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().compareTo(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T first() {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getDelegate().first();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T last() {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getDelegate().last();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<T> getFirstOptional() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().getFirstOptional();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<T> getLastOptional() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().getLastOptional();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object object) {
        Object object2 = this.getLock();
        synchronized (object2) {
            return this.getDelegate().indexOf(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableStack<T> toStack() {
        Object object = this.getLock();
        synchronized (object) {
            return ArrayStack.newStack(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionMutableSortedSet<T> partitionWhile(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().partitionWhile(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> distinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().distinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> takeWhile(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().takeWhile(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> dropWhile(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().dropWhile(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S> boolean corresponds(OrderedIterable<S> other, Predicate2<? super T, ? super S> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().corresponds(other, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(int startIndex, int endIndex, Procedure<? super T> procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().forEach(startIndex, endIndex, procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachWithIndex(int fromIndex, int toIndex, ObjectIntProcedure<? super T> objectIntProcedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().forEachWithIndex(fromIndex, toIndex, objectIntProcedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int detectIndex(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().detectIndex(predicate);
        }
    }

    @Override
    public MutableSortedSet<T> tap(Procedure<? super T> procedure) {
        return (MutableSortedSet)super.tap((Procedure)procedure);
    }

    @Override
    public MutableSortedSet<T> select(Predicate<? super T> predicate) {
        return (MutableSortedSet)super.select((Predicate)predicate);
    }

    @Override
    public <P> MutableSortedSet<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (MutableSortedSet)super.selectWith((Predicate2)predicate, (Object)parameter);
    }

    @Override
    public MutableSortedSet<T> reject(Predicate<? super T> predicate) {
        return (MutableSortedSet)super.reject((Predicate)predicate);
    }

    @Override
    public <P> MutableSortedSet<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (MutableSortedSet)super.rejectWith((Predicate2)predicate, (Object)parameter);
    }

    @Override
    public PartitionMutableSortedSet<T> partition(Predicate<? super T> predicate) {
        return (PartitionMutableSortedSet)super.partition((Predicate)predicate);
    }

    @Override
    public <P> PartitionMutableSortedSet<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (PartitionMutableSortedSet)super.partitionWith((Predicate2)predicate, (Object)parameter);
    }

    @Override
    public <S> MutableSortedSet<S> selectInstancesOf(Class<S> clazz) {
        return (MutableSortedSet)super.selectInstancesOf((Class)clazz);
    }

    @Override
    public <V> MutableList<V> collect(Function<? super T, ? extends V> function) {
        return (MutableList)super.collect((Function)function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableList<V> collectWithIndex(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectWithIndex(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V, R extends Collection<V>> R collectWithIndex(ObjectIntToObjectFunction<? super T, ? extends V> function, R target) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectWithIndex(function, target);
        }
    }

    @Override
    public MutableBooleanList collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return (MutableBooleanList)super.collectBoolean((BooleanFunction)booleanFunction);
    }

    @Override
    public MutableByteList collectByte(ByteFunction<? super T> byteFunction) {
        return (MutableByteList)super.collectByte((ByteFunction)byteFunction);
    }

    @Override
    public MutableCharList collectChar(CharFunction<? super T> charFunction) {
        return (MutableCharList)super.collectChar((CharFunction)charFunction);
    }

    @Override
    public MutableDoubleList collectDouble(DoubleFunction<? super T> doubleFunction) {
        return (MutableDoubleList)super.collectDouble((DoubleFunction)doubleFunction);
    }

    @Override
    public MutableFloatList collectFloat(FloatFunction<? super T> floatFunction) {
        return (MutableFloatList)super.collectFloat((FloatFunction)floatFunction);
    }

    @Override
    public MutableIntList collectInt(IntFunction<? super T> intFunction) {
        return (MutableIntList)super.collectInt((IntFunction)intFunction);
    }

    @Override
    public MutableLongList collectLong(LongFunction<? super T> longFunction) {
        return (MutableLongList)super.collectLong((LongFunction)longFunction);
    }

    @Override
    public MutableShortList collectShort(ShortFunction<? super T> shortFunction) {
        return (MutableShortList)super.collectShort((ShortFunction)shortFunction);
    }

    @Override
    public <P, V> MutableList<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return (MutableList)super.collectWith((Function2)function, (Object)parameter);
    }

    @Override
    public <V> MutableList<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return (MutableList)super.collectIf((Predicate)predicate, (Function)function);
    }

    @Override
    public <V> MutableList<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return (MutableList)super.flatCollect((Function)function);
    }

    @Override
    public <V> MutableSortedSetMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return (MutableSortedSetMultimap)super.groupBy((Function)function);
    }

    @Override
    public <V> MutableSortedSetMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return (MutableSortedSetMultimap)super.groupByEach((Function)function);
    }

    @Override
    public <S> MutableList<Pair<T, S>> zip(Iterable<S> that) {
        return (MutableList)super.zip((Iterable)that);
    }

    @Override
    public MutableSortedSet<Pair<T, Integer>> zipWithIndex() {
        return (MutableSortedSet)super.zipWithIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Set<T>> R unionInto(SetIterable<? extends T> set, R targetSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().unionInto(set, targetSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Set<T>> R intersectInto(SetIterable<? extends T> set, R targetSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().intersectInto(set, targetSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Set<T>> R differenceInto(SetIterable<? extends T> subtrahendSet, R targetSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().differenceInto(subtrahendSet, targetSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Set<T>> R symmetricDifferenceInto(SetIterable<? extends T> set, R targetSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().symmetricDifferenceInto(set, targetSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSubsetOf(SetIterable<? extends T> candidateSuperset) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().isSubsetOf(candidateSuperset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProperSubsetOf(SetIterable<? extends T> candidateSuperset) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().isProperSubsetOf(candidateSuperset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <B> LazyIterable<Pair<T, B>> cartesianProduct(SetIterable<B> set) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().cartesianProduct(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> union(SetIterable<? extends T> set) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().union(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> intersect(SetIterable<? extends T> set) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().intersect(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> difference(SetIterable<? extends T> subtrahendSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().difference(subtrahendSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> symmetricDifference(SetIterable<? extends T> setB) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().symmetricDifference(setB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<SortedSetIterable<T>> powerSet() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().powerSet();
        }
    }

    @Override
    public ParallelSortedSetIterable<T> asParallel(ExecutorService executorService, int batchSize) {
        return new SynchronizedParallelSortedSetIterable(this.getDelegate().asParallel(executorService, batchSize), (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableSortedSet<T> toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return SortedSets.immutable.withSortedSet(this.getDelegate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> asUnmodifiable() {
        Object object = this.getLock();
        synchronized (object) {
            return UnmodifiableSortedSet.of(this);
        }
    }

    @Override
    public MutableSortedSet<T> asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> subSet(T fromElement, T toElement) {
        Object object = this.getLock();
        synchronized (object) {
            return SynchronizedSortedSet.of(this.getDelegate().subSet(fromElement, toElement), this.getLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> headSet(T toElement) {
        Object object = this.getLock();
        synchronized (object) {
            return SynchronizedSortedSet.of(this.getDelegate().headSet(toElement), this.getLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> tailSet(T fromElement) {
        Object object = this.getLock();
        synchronized (object) {
            return SynchronizedSortedSet.of(this.getDelegate().tailSet(fromElement), this.getLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reverseForEach(Procedure<? super T> procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().reverseForEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reverseForEachWithIndex(ObjectIntProcedure<? super T> procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().reverseForEachWithIndex(procedure);
        }
    }

    @Override
    public LazyIterable<T> asReversed() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".asReversed() not implemented yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> toReversed() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toReversed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int detectLastIndex(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().detectLastIndex(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> take(int count2) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().take(count2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSortedSet<T> drop(int count2) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().drop(count2);
        }
    }
}

