/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable;

import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.factory.list.MutableListFactory;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.list.mutable.MultiReaderFastList;

public enum MultiReaderMutableListFactory implements MutableListFactory
{
    INSTANCE;


    @Override
    public <T> MutableList<T> empty() {
        return MultiReaderFastList.newList();
    }

    @Override
    public <T> MutableList<T> of() {
        return this.empty();
    }

    @Override
    public <T> MutableList<T> with() {
        return this.empty();
    }

    @Override
    public <T> MutableList<T> of(T ... items) {
        return this.with(items);
    }

    @Override
    public <T> MutableList<T> with(T ... items) {
        return MultiReaderFastList.newListWith(items);
    }

    @Override
    public <T> MutableList<T> ofInitialCapacity(int capacity) {
        return this.withInitialCapacity(capacity);
    }

    @Override
    public <T> MutableList<T> withInitialCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        return MultiReaderFastList.newList(capacity);
    }

    @Override
    public <T> MutableList<T> ofAll(Iterable<? extends T> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public <T> MutableList<T> withAll(Iterable<? extends T> iterable) {
        return MultiReaderFastList.newList(iterable);
    }

    @Override
    public <T> MutableList<T> withNValues(int size2, Function0<? extends T> factory) {
        MultiReaderFastList<T> newFastList = MultiReaderFastList.newList(size2);
        for (int i = 0; i < size2; ++i) {
            newFastList.add(factory.value());
        }
        return newFastList;
    }
}

