/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.jar.asm.MethodVisitor;

public interface StackManipulation {
    public boolean isValid();

    public Size apply(MethodVisitor var1, Implementation.Context var2);

    @HashCodeAndEqualsPlugin.Enhance
    public static class Compound
    implements StackManipulation {
        private final List<StackManipulation> stackManipulations = new ArrayList<StackManipulation>();

        public Compound(StackManipulation ... stackManipulation) {
            this(Arrays.asList(stackManipulation));
        }

        public Compound(List<? extends StackManipulation> stackManipulations) {
            for (StackManipulation stackManipulation : stackManipulations) {
                if (stackManipulation instanceof Compound) {
                    this.stackManipulations.addAll(((Compound)stackManipulation).stackManipulations);
                    continue;
                }
                if (stackManipulation instanceof Trivial) continue;
                this.stackManipulations.add(stackManipulation);
            }
        }

        @Override
        public boolean isValid() {
            for (StackManipulation stackManipulation : this.stackManipulations) {
                if (stackManipulation.isValid()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            Size size2 = new Size(0, 0);
            for (StackManipulation stackManipulation : this.stackManipulations) {
                size2 = size2.aggregate(stackManipulation.apply(methodVisitor, implementationContext));
            }
            return size2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.stackManipulations.equals(((Compound)object).stackManipulations);
        }

        public int hashCode() {
            return 17 * 31 + this.stackManipulations.hashCode();
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class Size {
        private final int sizeImpact;
        private final int maximalSize;

        public Size(int sizeImpact, int maximalSize) {
            this.sizeImpact = sizeImpact;
            this.maximalSize = maximalSize;
        }

        public int getSizeImpact() {
            return this.sizeImpact;
        }

        public int getMaximalSize() {
            return this.maximalSize;
        }

        public Size aggregate(Size other) {
            return this.aggregate(other.sizeImpact, other.maximalSize);
        }

        private Size aggregate(int sizeChange, int interimMaximalSize) {
            return new Size(this.sizeImpact + sizeChange, Math.max(this.maximalSize, this.sizeImpact + interimMaximalSize));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (this.sizeImpact != ((Size)object).sizeImpact) {
                return false;
            }
            return this.maximalSize == ((Size)object).maximalSize;
        }

        public int hashCode() {
            return (17 * 31 + this.sizeImpact) * 31 + this.maximalSize;
        }
    }

    public static enum Trivial implements StackManipulation
    {
        INSTANCE;


        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return StackSize.ZERO.toIncreasingSize();
        }
    }

    public static enum Illegal implements StackManipulation
    {
        INSTANCE;


        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            throw new IllegalStateException("An illegal stack manipulation must not be applied");
        }
    }
}

