/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.progress;

import java.util.LinkedHashSet;
import java.util.Set;
import org.mockito.internal.configuration.GlobalConfiguration;
import org.mockito.internal.debugging.Localized;
import org.mockito.internal.debugging.LocationImpl;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.progress.ArgumentMatcherStorage;
import org.mockito.internal.progress.ArgumentMatcherStorageImpl;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.invocation.Location;
import org.mockito.listeners.MockCreationListener;
import org.mockito.listeners.MockitoListener;
import org.mockito.listeners.VerificationListener;
import org.mockito.mock.MockCreationSettings;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import org.mockito.verification.VerificationStrategy;

public class MockingProgressImpl
implements MockingProgress {
    private final ArgumentMatcherStorage argumentMatcherStorage = new ArgumentMatcherStorageImpl();
    private OngoingStubbing<?> ongoingStubbing;
    private Localized<VerificationMode> verificationMode;
    private Location stubbingInProgress = null;
    private VerificationStrategy verificationStrategy;
    private final Set<MockitoListener> listeners = new LinkedHashSet<MockitoListener>();

    public MockingProgressImpl() {
        this.verificationStrategy = MockingProgressImpl.getDefaultVerificationStrategy();
    }

    public static VerificationStrategy getDefaultVerificationStrategy() {
        return new VerificationStrategy(){

            @Override
            public VerificationMode maybeVerifyLazily(VerificationMode mode) {
                return mode;
            }
        };
    }

    public void reportOngoingStubbing(OngoingStubbing ongoingStubbing) {
        this.ongoingStubbing = ongoingStubbing;
    }

    @Override
    public OngoingStubbing<?> pullOngoingStubbing() {
        OngoingStubbing<?> temp = this.ongoingStubbing;
        this.ongoingStubbing = null;
        return temp;
    }

    @Override
    public Set<VerificationListener> verificationListeners() {
        LinkedHashSet<VerificationListener> verificationListeners = new LinkedHashSet<VerificationListener>();
        for (MockitoListener listener2 : this.listeners) {
            if (!(listener2 instanceof VerificationListener)) continue;
            verificationListeners.add((VerificationListener)listener2);
        }
        return verificationListeners;
    }

    @Override
    public void verificationStarted(VerificationMode verify2) {
        this.validateState();
        this.resetOngoingStubbing();
        this.verificationMode = new Localized<VerificationMode>(verify2);
    }

    @Override
    public void resetOngoingStubbing() {
        this.ongoingStubbing = null;
    }

    @Override
    public VerificationMode pullVerificationMode() {
        if (this.verificationMode == null) {
            return null;
        }
        VerificationMode temp = this.verificationMode.getObject();
        this.verificationMode = null;
        return temp;
    }

    @Override
    public void stubbingStarted() {
        this.validateState();
        this.stubbingInProgress = new LocationImpl();
    }

    @Override
    public void validateState() {
        this.validateMostStuff();
        if (this.stubbingInProgress != null) {
            Location temp = this.stubbingInProgress;
            this.stubbingInProgress = null;
            throw Reporter.unfinishedStubbing(temp);
        }
    }

    private void validateMostStuff() {
        GlobalConfiguration.validate();
        if (this.verificationMode != null) {
            Location location = this.verificationMode.getLocation();
            this.verificationMode = null;
            throw Reporter.unfinishedVerificationException(location);
        }
        this.getArgumentMatcherStorage().validateState();
    }

    @Override
    public void stubbingCompleted() {
        this.stubbingInProgress = null;
    }

    public String toString() {
        return "ongoingStubbing: " + this.ongoingStubbing + ", verificationMode: " + this.verificationMode + ", stubbingInProgress: " + this.stubbingInProgress;
    }

    @Override
    public void reset() {
        this.stubbingInProgress = null;
        this.verificationMode = null;
        this.getArgumentMatcherStorage().reset();
    }

    @Override
    public ArgumentMatcherStorage getArgumentMatcherStorage() {
        return this.argumentMatcherStorage;
    }

    @Override
    public void mockingStarted(Object mock, MockCreationSettings settings) {
        for (MockitoListener listener2 : this.listeners) {
            if (!(listener2 instanceof MockCreationListener)) continue;
            ((MockCreationListener)listener2).onMockCreated(mock, settings);
        }
        this.validateMostStuff();
    }

    @Override
    public void addListener(MockitoListener listener2) {
        for (MockitoListener existing : this.listeners) {
            if (!existing.getClass().equals(listener2.getClass())) continue;
            Reporter.redundantMockitoListener(listener2.getClass().getSimpleName());
        }
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(MockitoListener listener2) {
        this.listeners.remove(listener2);
    }

    @Override
    public void setVerificationStrategy(VerificationStrategy strategy) {
        this.verificationStrategy = strategy;
    }

    @Override
    public VerificationMode maybeVerifyLazily(VerificationMode mode) {
        return this.verificationStrategy.maybeVerifyLazily(mode);
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }
}

