/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.iterator.MutableCharIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.CharSet;
import org.eclipse.collections.api.set.primitive.ImmutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.primitive.CharSets;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractSentinelValues;
import org.eclipse.collections.impl.map.mutable.primitive.MutableCharKeysMap;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedCharSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableCharSet;

public abstract class AbstractMutableCharKeySet
implements MutableCharSet {
    private static final char EMPTY_KEY = '\u0000';
    private static final char REMOVED_KEY = '\u0001';

    private static boolean isEmptyKey(char key) {
        return key == '\u0000';
    }

    private static boolean isRemovedKey(char key) {
        return key == '\u0001';
    }

    private static boolean isNonSentinel(char key) {
        return !AbstractMutableCharKeySet.isEmptyKey(key) && !AbstractMutableCharKeySet.isRemovedKey(key);
    }

    protected abstract char getKeyAtIndex(int var1);

    protected abstract int getTableSize();

    protected abstract MutableCharKeysMap getOuter();

    protected abstract AbstractSentinelValues getSentinelValues();

    @Override
    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(CharProcedure procedure) {
        this.getOuter().forEachKey(procedure);
    }

    @Override
    public int count(CharPredicate predicate) {
        int count2 = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept('\u0000')) {
                ++count2;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept('\u0001')) {
                ++count2;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableCharKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept('\u0000')) {
                return true;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept('\u0001')) {
                return true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableCharKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept('\u0000')) {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept('\u0001')) {
                return false;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableCharKeySet.isNonSentinel(this.getKeyAtIndex(i)) || predicate.accept(this.getKeyAtIndex(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept('\u0000')) {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept('\u0001')) {
                return false;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableCharKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(char element) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean addAll(char ... source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean addAll(CharIterable source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableCharSet select(CharPredicate predicate) {
        CharHashSet result = new CharHashSet();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept('\u0000')) {
                result.add('\u0000');
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept('\u0001')) {
                result.add('\u0001');
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableCharKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            result.add(this.getKeyAtIndex(i));
        }
        return result;
    }

    @Override
    public MutableCharSet reject(CharPredicate predicate) {
        CharHashSet result = new CharHashSet();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept('\u0000')) {
                result.add('\u0000');
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept('\u0001')) {
                result.add('\u0001');
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableCharKeySet.isNonSentinel(this.getKeyAtIndex(i)) || predicate.accept(this.getKeyAtIndex(i))) continue;
            result.add(this.getKeyAtIndex(i));
        }
        return result;
    }

    @Override
    public MutableCharSet with(char element) {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableCharSet without(char element) {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableCharSet withAll(CharIterable elements) {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableCharSet withoutAll(CharIterable elements) {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public <V> MutableSet<V> collect(CharToObjectFunction<? extends V> function) {
        MutableSet result = Sets.mutable.with();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result.add(function.valueOf('\u0000'));
            }
            if (this.getSentinelValues().containsOneKey) {
                result.add(function.valueOf('\u0001'));
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableCharKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result.add(function.valueOf(this.getKeyAtIndex(i)));
        }
        return result;
    }

    @Override
    public boolean remove(char key) {
        int oldSize = this.getOuter().size();
        this.getOuter().removeKey(key);
        return oldSize != this.getOuter().size();
    }

    @Override
    public boolean removeAll(CharIterable source) {
        int oldSize = this.getOuter().size();
        CharIterator iterator2 = source.charIterator();
        while (iterator2.hasNext()) {
            this.getOuter().removeKey(iterator2.next());
        }
        return oldSize != this.getOuter().size();
    }

    @Override
    public boolean removeAll(char ... source) {
        int oldSize = this.getOuter().size();
        for (char item : source) {
            this.getOuter().removeKey(item);
        }
        return oldSize != this.getOuter().size();
    }

    @Override
    public void clear() {
        this.getOuter().clear();
    }

    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept('\u0000')) {
                return '\u0000';
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept('\u0001')) {
                return '\u0001';
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableCharKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            return this.getKeyAtIndex(i);
        }
        return ifNone;
    }

    @Override
    public MutableCharSet asUnmodifiable() {
        return UnmodifiableCharSet.of(this);
    }

    @Override
    public MutableCharSet asSynchronized() {
        return SynchronizedCharSet.of(this);
    }

    @Override
    public long sum() {
        long result = 0L;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result += 0L;
            }
            if (this.getSentinelValues().containsOneKey) {
                ++result;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableCharKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result += (long)this.getKeyAtIndex(i);
        }
        return result;
    }

    @Override
    public char max() {
        if (this.getOuter().isEmpty()) {
            throw new NoSuchElementException();
        }
        char max2 = '\u0000';
        boolean isMaxSet = false;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                max2 = '\u0000';
                isMaxSet = true;
            }
            if (this.getSentinelValues().containsOneKey) {
                max2 = '\u0001';
                isMaxSet = true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableCharKeySet.isNonSentinel(this.getKeyAtIndex(i)) || isMaxSet && max2 >= this.getKeyAtIndex(i)) continue;
            max2 = this.getKeyAtIndex(i);
            isMaxSet = true;
        }
        return max2;
    }

    @Override
    public char maxIfEmpty(char defaultValue) {
        if (this.getOuter().isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    @Override
    public char min() {
        if (this.getOuter().isEmpty()) {
            throw new NoSuchElementException();
        }
        char min2 = '\u0000';
        boolean isMinSet = false;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                min2 = '\u0000';
                isMinSet = true;
            }
            if (this.getSentinelValues().containsOneKey && !isMinSet) {
                min2 = '\u0001';
                isMinSet = true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableCharKeySet.isNonSentinel(this.getKeyAtIndex(i)) || isMinSet && this.getKeyAtIndex(i) >= min2) continue;
            min2 = this.getKeyAtIndex(i);
            isMinSet = true;
        }
        return min2;
    }

    @Override
    public char minIfEmpty(char defaultValue) {
        if (this.getOuter().isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    @Override
    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        char[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            char first = sortedArray[middleIndex];
            char second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public char[] toSortedArray() {
        char[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableCharList toSortedList() {
        return CharArrayList.newList(this).sortThis();
    }

    @Override
    public char[] toArray() {
        int size2 = this.getOuter().size();
        final char[] result = new char[size2];
        this.getOuter().forEachKey(new CharProcedure(){
            private int index;

            @Override
            public void value(char each2) {
                result[this.index] = each2;
                ++this.index;
            }
        });
        return result;
    }

    @Override
    public boolean contains(char value) {
        return this.getOuter().containsKey(value);
    }

    @Override
    public boolean containsAll(char ... source) {
        for (char item : source) {
            if (this.getOuter().containsKey(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(CharIterable source) {
        CharIterator iterator2 = source.charIterator();
        while (iterator2.hasNext()) {
            if (this.getOuter().containsKey(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableCharList toList() {
        return CharArrayList.newList(this);
    }

    @Override
    public MutableCharSet toSet() {
        return CharHashSet.newSet(this);
    }

    @Override
    public MutableCharBag toBag() {
        return CharHashBag.newBag(this);
    }

    @Override
    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter(this);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result = function.valueOf(result, '\u0000');
            }
            if (this.getSentinelValues().containsOneKey) {
                result = function.valueOf(result, '\u0001');
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableCharKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result = function.valueOf(result, this.getKeyAtIndex(i));
        }
        return result;
    }

    @Override
    public ImmutableCharSet toImmutable() {
        return CharSets.immutable.withAll(this);
    }

    @Override
    public int size() {
        return this.getOuter().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getOuter().isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.getOuter().notEmpty();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharSet)) {
            return false;
        }
        CharSet other = (CharSet)obj;
        return this.size() == other.size() && this.containsAll(other.toArray());
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result += 0;
            }
            if (this.getSentinelValues().containsOneKey) {
                ++result;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableCharKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result += this.getKeyAtIndex(i);
        }
        return result;
    }

    @Override
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.getSentinelValues() != null) {
                if (this.getSentinelValues().containsZeroKey) {
                    appendable.append(String.valueOf('\u0000'));
                    first = false;
                }
                if (this.getSentinelValues().containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf('\u0001'));
                    first = false;
                }
            }
            for (int i = 0; i < this.getTableSize(); ++i) {
                if (!AbstractMutableCharKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.getKeyAtIndex(i)));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RichIterable<CharIterable> chunk(int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        MutableList<CharIterable> result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size2) {
                result.add(CharSets.mutable.withAll(this));
            } else {
                MutableCharIterator iterator2 = this.charIterator();
                while (iterator2.hasNext()) {
                    MutableCharSet batch = CharSets.mutable.empty();
                    for (int i = 0; i < size2 && iterator2.hasNext(); ++i) {
                        batch.add(iterator2.next());
                    }
                    result.add(batch);
                }
            }
        }
        return result;
    }
}

