/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableIntCharMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableIntCharMap;
import org.eclipse.collections.api.map.primitive.IntCharMap;
import org.eclipse.collections.impl.factory.primitive.IntCharMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntCharEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntCharHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntCharSingletonMap;

public enum ImmutableIntCharMapFactoryImpl implements ImmutableIntCharMapFactory
{
    INSTANCE;


    @Override
    public ImmutableIntCharMap empty() {
        return ImmutableIntCharEmptyMap.INSTANCE;
    }

    @Override
    public ImmutableIntCharMap of() {
        return this.empty();
    }

    @Override
    public ImmutableIntCharMap with() {
        return this.empty();
    }

    @Override
    public ImmutableIntCharMap of(int key, char value) {
        return this.with(key, value);
    }

    @Override
    public ImmutableIntCharMap with(int key, char value) {
        return new ImmutableIntCharSingletonMap(key, value);
    }

    @Override
    public ImmutableIntCharMap ofAll(IntCharMap map2) {
        return this.withAll(map2);
    }

    @Override
    public ImmutableIntCharMap withAll(IntCharMap map2) {
        if (map2 instanceof ImmutableIntCharMap) {
            return (ImmutableIntCharMap)map2;
        }
        if (map2.isEmpty()) {
            return this.with();
        }
        if (map2.size() == 1) {
            int key = map2.keysView().intIterator().next();
            return new ImmutableIntCharSingletonMap(key, map2.get(key));
        }
        return new ImmutableIntCharHashMap(map2);
    }

    @Override
    public <T> ImmutableIntCharMap from(Iterable<T> iterable, IntFunction<? super T> keyFunction, CharFunction<? super T> valueFunction) {
        return IntCharMaps.mutable.from(iterable, keyFunction, valueFunction).toImmutable();
    }
}

