/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version.impl;

import com.github.zafarkhaja.semver.Version;
import net.ossindex.version.IVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticVersion
implements Comparable<IVersion>,
IVersion {
    private static final Logger LOG = LoggerFactory.getLogger(SemanticVersion.class);
    protected Version head;
    protected int significantDigits = -1;

    public SemanticVersion(String buf) {
        buf = buf.replace('_', '-');
        buf = buf.replace('~', '-');
        this.setVersion(buf);
    }

    public SemanticVersion(int major) {
        this.head = Version.forIntegers(major);
        this.significantDigits = 1;
    }

    public SemanticVersion(int major, int minor) {
        this.head = Version.forIntegers(major, minor);
        this.significantDigits = 2;
    }

    public SemanticVersion(int major, int minor, int patch) {
        this.head = Version.forIntegers(major, minor, patch);
        this.significantDigits = 3;
    }

    protected SemanticVersion() {
    }

    protected void setVersion(String buf) {
        while (buf.endsWith("-")) {
            buf = buf.substring(0, buf.length() - 1);
        }
        while (buf.endsWith(".")) {
            buf = buf.substring(0, buf.length() - 1);
        }
        this.head = Version.valueOf(buf);
        this.significantDigits = -1;
    }

    @Override
    public int getMajor() {
        if (this.head == null) {
            return 0;
        }
        return this.head.getMajorVersion();
    }

    @Override
    public int getMinor() {
        if (this.head == null) {
            return 0;
        }
        return this.head.getMinorVersion();
    }

    @Override
    public int getPatch() {
        if (this.head == null) {
            return 0;
        }
        return this.head.getPatchVersion();
    }

    @Override
    public int getBuild() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (o instanceof SemanticVersion) {
            SemanticVersion v = (SemanticVersion)o;
            if (this.head != null) {
                return this.head.equals(v.head);
            }
            return super.equals(v);
        }
        return false;
    }

    public int hashCode() {
        if (this.head != null) {
            return this.head.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public int compareTo(IVersion other) {
        if (other instanceof SemanticVersion) {
            SemanticVersion sv = (SemanticVersion)other;
            return this.head.compareTo(sv.head);
        }
        return this.toString().compareTo(other.toString());
    }

    public String toString() {
        return this.head.toString();
    }

    @Override
    public boolean isStable() {
        return true;
    }

    public Version getVersionImpl() {
        return this.head;
    }

    public boolean lessThan(IVersion version) {
        if (!(version instanceof SemanticVersion)) {
            return false;
        }
        return this.head.lessThan(((SemanticVersion)version).head);
    }

    public boolean lessThanOrEqualTo(IVersion version) {
        if (!(version instanceof SemanticVersion)) {
            return false;
        }
        return this.head.lessThanOrEqualTo(((SemanticVersion)version).head);
    }

    public boolean greaterThan(IVersion version) {
        if (!(version instanceof SemanticVersion)) {
            return false;
        }
        return this.head.greaterThan(((SemanticVersion)version).head);
    }

    public boolean greaterThanOrEqualTo(IVersion version) {
        if (!(version instanceof SemanticVersion)) {
            return false;
        }
        return this.head.greaterThanOrEqualTo(((SemanticVersion)version).head);
    }

    public SemanticVersion getNextVersion() {
        int major = this.head.getMajorVersion();
        int minor = this.head.getMinorVersion();
        int patch = this.head.getPatchVersion();
        return new SemanticVersion(major, minor, patch + 1);
    }

    public SemanticVersion getPrevVersion() {
        int major = this.head.getMajorVersion();
        int minor = this.head.getMinorVersion();
        int patch = this.head.getPatchVersion();
        if (patch > 0) {
            return new SemanticVersion(major, minor, patch - 1);
        }
        if (minor > 0) {
            return new SemanticVersion(major, minor - 1, 999);
        }
        if (major > 0) {
            return new SemanticVersion(major - 1, 999, 999);
        }
        return new SemanticVersion(0, 0, 0);
    }

    public SemanticVersion getNextParentVersion() {
        int major = this.head.getMajorVersion();
        int minor = this.head.getMinorVersion();
        int patch = this.head.getPatchVersion();
        switch (this.significantDigits) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                minor = 0;
                patch = 0;
                return new SemanticVersion(++major, minor, patch);
            }
            case 3: {
                patch = 0;
                return new SemanticVersion(major, ++minor, patch);
            }
        }
        throw new UnsupportedOperationException();
    }
}

