/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.LinkedList;
import net.ossindex.version.IVersion;
import net.ossindex.version.IVersionRange;
import net.ossindex.version.InvalidRangeException;
import net.ossindex.version.InvalidRangeRuntimeException;
import net.ossindex.version.impl.AndRange;
import net.ossindex.version.impl.NamedVersion;
import net.ossindex.version.impl.OrRange;
import net.ossindex.version.impl.VersionErrorListener;
import net.ossindex.version.impl.VersionListener;
import net.ossindex.version.impl.VersionRange;
import net.ossindex.version.impl.VersionSet;
import net.ossindex.version.parser.VersionLexer;
import net.ossindex.version.parser.VersionParser;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class VersionFactory {
    private static VersionFactory strictInstance;
    private static VersionFactory instance;
    private final boolean strict;

    private VersionFactory(boolean strict) {
        this.strict = strict;
    }

    public static synchronized VersionFactory getVersionFactory() {
        if (instance == null) {
            instance = new VersionFactory(false);
        }
        return instance;
    }

    public static synchronized VersionFactory getStrictVersionFactory() {
        if (strictInstance == null) {
            strictInstance = new VersionFactory(true);
        }
        return strictInstance;
    }

    public IVersion getVersion(String vstring) throws InvalidRangeException {
        IVersionRange range = this.getRange(vstring);
        if (range == null) {
            return null;
        }
        return range.getMinimum();
    }

    public IVersion getVersion(String hint, String version) throws InvalidRangeException {
        return this.getVersion(version);
    }

    public IVersionRange getRange(String vstring) throws InvalidRangeException {
        if (vstring == null || vstring.isEmpty()) {
            NamedVersion version = new NamedVersion("");
            return new VersionSet(version);
        }
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(vstring.getBytes(StandardCharsets.UTF_8));
            ANTLRInputStream input = new ANTLRInputStream(stream);
            VersionErrorListener errorListener = new VersionErrorListener();
            VersionLexer lexer = new VersionLexer(input);
            lexer.removeErrorListeners();
            lexer.addErrorListener(errorListener);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            VersionParser parser = new VersionParser(tokens);
            parser.addErrorListener(errorListener);
            VersionParser.RangeContext context = parser.range();
            ParseTreeWalker walker = new ParseTreeWalker();
            VersionListener listener2 = new VersionListener(this.strict);
            walker.walk(listener2, context);
            IVersionRange range = listener2.getRange();
            if (errorListener.hasErrors()) {
                if (this.strict) {
                    throw new InvalidRangeException("Parse errors on " + vstring);
                }
                range.setHasErrors(true);
            }
            return range;
        }
        catch (EmptyStackException e) {
            if (this.strict) {
                throw new InvalidRangeException(e);
            }
            System.err.println("ERROR: Could not parse: " + vstring);
        }
        catch (InvalidRangeRuntimeException e) {
            throw new InvalidRangeException(e.getMessage(), e);
        }
        catch (Exception e) {
            if (this.strict) {
                throw new InvalidRangeException(e);
            }
            System.err.println("ERROR: Could not parse: " + vstring);
        }
        NamedVersion version = new NamedVersion(vstring);
        return new VersionSet(version);
    }

    public IVersionRange getRange(String[] versions) throws InvalidRangeException {
        if (versions == null) {
            return null;
        }
        IVersionRange results = null;
        for (String version : versions) {
            IVersionRange range = this.getRange(version);
            results = results == null ? range : new OrRange(results, range);
        }
        return results;
    }

    public IVersionRange getRange(Collection<String> versions) throws InvalidRangeException {
        if (versions == null) {
            return null;
        }
        return this.getRange(versions.toArray(new String[versions.size()]));
    }

    public boolean isMavenRange(String vstring) throws InvalidRangeException {
        IVersionRange range = this.getRange(vstring);
        return "maven".equals(range.getType());
    }

    public IVersionRange merge(IVersionRange ... ranges) {
        int lastIndex;
        if (ranges.length < 2) {
            return ranges[0];
        }
        if (!(ranges[0] instanceof VersionRange)) {
            if (!(ranges[0] instanceof OrRange)) {
                throw new UnsupportedOperationException("Incorrect type for ranges[0]");
            }
            if (((OrRange)ranges[0]).size() != 2) {
                throw new UnsupportedOperationException("Incorrect size for ranges[0]");
            }
        } else if (!((VersionRange)ranges[0]).isUnbounded()) {
            throw new UnsupportedOperationException("ranges[0] should be unbounded (> or >=)");
        }
        if (!(ranges[lastIndex = ranges.length - 1] instanceof VersionRange)) {
            if (!(ranges[lastIndex] instanceof OrRange)) {
                throw new UnsupportedOperationException("Incorrect type for ranges[last]");
            }
            if (((OrRange)ranges[lastIndex]).size() != 2) {
                throw new UnsupportedOperationException("Incorrect size for ranges[last]");
            }
        } else if (((VersionRange)ranges[lastIndex]).isUnbounded()) {
            throw new UnsupportedOperationException("ranges[0] should be bounded (< or <=)");
        }
        for (int i = 1; i < lastIndex; ++i) {
            if (!(ranges[i] instanceof OrRange)) {
                throw new UnsupportedOperationException("Incorrect type for ranges[" + i + "]");
            }
            if (((OrRange)ranges[i]).size() == 2) continue;
            throw new UnsupportedOperationException("Incorrect size for ranges[" + i + "]");
        }
        LinkedList<IVersionRange> results = new LinkedList<IVersionRange>();
        IVersionRange last = null;
        for (int i = 0; i < ranges.length; ++i) {
            OrRange orange;
            IVersionRange range = ranges[i];
            if (last == null) {
                if (range instanceof VersionRange) {
                    last = range;
                    continue;
                }
                orange = (OrRange)range;
                results.add(orange.first());
                last = orange.last();
                continue;
            }
            if (range instanceof VersionRange) {
                AndRange arange = new AndRange(last, range);
                results.add(arange);
                last = null;
                continue;
            }
            orange = (OrRange)range;
            AndRange arange = new AndRange(last, orange.first());
            results.add(arange);
            last = orange.last();
        }
        if (last != null) {
            results.add(last);
        }
        return new OrRange(results);
    }
}

