/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal.parameters;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.type.NullType;
import junitparams.Parameters;
import junitparams.internal.parameters.ParametrizationStrategy;
import junitparams.internal.parameters.ParamsFromMethodCommon;
import org.junit.runners.model.FrameworkMethod;

class ParametersFromExternalClassProvideMethod
implements ParametrizationStrategy {
    private final ParamsFromMethodCommon paramsFromMethodCommon;
    private Parameters annotation;

    ParametersFromExternalClassProvideMethod(FrameworkMethod frameworkMethod) {
        this.paramsFromMethodCommon = new ParamsFromMethodCommon(frameworkMethod);
        this.annotation = frameworkMethod.getAnnotation(Parameters.class);
    }

    @Override
    public Object[] getParameters() {
        Class<?> sourceClass = this.annotation.source();
        return this.fillResultWithAllParamProviderMethods(sourceClass);
    }

    @Override
    public boolean isApplicable() {
        return this.annotation != null && !this.annotation.source().isAssignableFrom(NullType.class) && this.annotation.method().isEmpty();
    }

    private Object[] fillResultWithAllParamProviderMethods(Class<?> sourceClass) {
        if (sourceClass.isEnum()) {
            return sourceClass.getEnumConstants();
        }
        List<Object> result = this.getParamsFromSourceHierarchy(sourceClass);
        if (result.isEmpty()) {
            throw new RuntimeException("No methods starting with provide or they return no result in the parameters source class: " + sourceClass.getName());
        }
        return result.toArray();
    }

    private List<Object> getParamsFromSourceHierarchy(Class<?> sourceClass) {
        ArrayList<Object> result = new ArrayList<Object>();
        while (sourceClass.getSuperclass() != null) {
            result.addAll(this.gatherParamsFromAllMethodsFrom(sourceClass));
            sourceClass = sourceClass.getSuperclass();
        }
        return result;
    }

    private List<Object> gatherParamsFromAllMethodsFrom(Class<?> sourceClass) {
        Method[] methods;
        ArrayList<Object> result = new ArrayList<Object>();
        for (Method prividerMethod : methods = sourceClass.getDeclaredMethods()) {
            if (!prividerMethod.getName().startsWith("provide")) continue;
            if (!Modifier.isStatic(prividerMethod.getModifiers())) {
                throw new RuntimeException("Parameters source method " + prividerMethod.getName() + " is not declared as static. Change it to a static method.");
            }
            try {
                result.addAll(Arrays.asList(this.paramsFromMethodCommon.getDataFromMethod(prividerMethod)));
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot invoke parameters source method: " + prividerMethod.getName(), e);
            }
        }
        return result;
    }
}

