/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedLongProcedure;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;

public final class ImmutableLongSetSerializationProxy
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private LongSet set;

    public ImmutableLongSetSerializationProxy() {
    }

    public ImmutableLongSetSerializationProxy(LongSet set) {
        this.set = set;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.set.size());
        try {
            this.set.forEach(new CheckedLongProcedure(){

                @Override
                public void safeValue(long item) throws Exception {
                    out.writeLong(item);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size2 = in.readInt();
        LongHashSet deserializedSet = new LongHashSet(size2);
        for (int i = 0; i < size2; ++i) {
            deserializedSet.add(in.readLong());
        }
        this.set = deserializedSet;
    }

    private Object readResolve() {
        return this.set.toImmutable();
    }
}

