/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel;

import org.eclipse.collections.api.ParallelIterable;
import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.multimap.bag.UnsortedBagMultimap;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterable;
import org.eclipse.collections.impl.lazy.parallel.Batch;
import org.eclipse.collections.impl.lazy.parallel.ParallelDistinctIterable;
import org.eclipse.collections.impl.lazy.parallel.ParallelSelectIterable;
import org.eclipse.collections.impl.lazy.parallel.set.ParallelCollectIterable;
import org.eclipse.collections.impl.lazy.parallel.set.ParallelFlatCollectIterable;
import org.eclipse.collections.impl.multimap.bag.SynchronizedPutHashBagMultimap;

@Beta
public abstract class AbstractParallelIterableImpl<T, B extends Batch<T>>
extends AbstractParallelIterable<T, B> {
    @Override
    protected boolean isOrdered() {
        return false;
    }

    @Override
    public ParallelUnsortedSetIterable<T> asUnique() {
        return new ParallelDistinctIterable(this);
    }

    @Override
    public ParallelIterable<T> select(Predicate<? super T> predicate) {
        return new ParallelSelectIterable<T>(this, predicate);
    }

    @Override
    public <P> ParallelIterable<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.select(Predicates.bind(predicate, parameter));
    }

    @Override
    public <S> ParallelIterable<S> selectInstancesOf(Class<S> clazz) {
        return this.select(Predicates.instanceOf(clazz));
    }

    @Override
    public ParallelIterable<T> reject(Predicate<? super T> predicate) {
        return this.select(Predicates.not(predicate));
    }

    @Override
    public <P> ParallelIterable<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.reject(Predicates.bind(predicate, parameter));
    }

    @Override
    public <V> ParallelIterable<V> collect(Function<? super T, ? extends V> function) {
        return new ParallelCollectIterable<T, V>(this, function);
    }

    @Override
    public <P, V> ParallelIterable<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collect(Functions.bind(function, parameter));
    }

    @Override
    public <V> ParallelIterable<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.select(predicate).collect(function);
    }

    @Override
    public <V> ParallelIterable<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return new ParallelFlatCollectIterable(this, function);
    }

    @Override
    public <V> UnsortedBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        SynchronizedPutHashBagMultimap result = SynchronizedPutHashBagMultimap.newMultimap();
        this.forEach(each2 -> {
            Object key = function.valueOf(each2);
            result.put(key, each2);
        });
        return result;
    }

    @Override
    public <V> UnsortedBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        SynchronizedPutHashBagMultimap result = SynchronizedPutHashBagMultimap.newMultimap();
        this.forEach(each2 -> {
            Iterable keys2 = (Iterable)function.valueOf(each2);
            for (Object key : keys2) {
                result.put(key, each2);
            }
        });
        return result;
    }
}

