/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api;

import java.util.Collection;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.IntSummaryStatistics;
import java.util.LongSummaryStatistics;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.InternalIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.Bag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.MutableBagIterable;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.ObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ObjectLongMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.partition.PartitionIterable;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.tuple.Pair;

public interface RichIterable<T>
extends InternalIterable<T> {
    public int size();

    public boolean isEmpty();

    default public boolean notEmpty() {
        return !this.isEmpty();
    }

    @Deprecated
    public T getFirst();

    @Deprecated
    public T getLast();

    default public T getOnly() {
        if (this.size() == 1) {
            return this.getFirst();
        }
        throw new IllegalStateException("Size must be 1 but was " + this.size());
    }

    public boolean contains(Object var1);

    public boolean containsAllIterable(Iterable<?> var1);

    public boolean containsAll(Collection<?> var1);

    public boolean containsAllArguments(Object ... var1);

    public RichIterable<T> tap(Procedure<? super T> var1);

    public void each(Procedure<? super T> var1);

    public RichIterable<T> select(Predicate<? super T> var1);

    public <R extends Collection<T>> R select(Predicate<? super T> var1, R var2);

    public <P> RichIterable<T> selectWith(Predicate2<? super T, ? super P> var1, P var2);

    public <P, R extends Collection<T>> R selectWith(Predicate2<? super T, ? super P> var1, P var2, R var3);

    public RichIterable<T> reject(Predicate<? super T> var1);

    public <P> RichIterable<T> rejectWith(Predicate2<? super T, ? super P> var1, P var2);

    public <R extends Collection<T>> R reject(Predicate<? super T> var1, R var2);

    public <P, R extends Collection<T>> R rejectWith(Predicate2<? super T, ? super P> var1, P var2, R var3);

    public PartitionIterable<T> partition(Predicate<? super T> var1);

    public <P> PartitionIterable<T> partitionWith(Predicate2<? super T, ? super P> var1, P var2);

    public <S> RichIterable<S> selectInstancesOf(Class<S> var1);

    public <V> RichIterable<V> collect(Function<? super T, ? extends V> var1);

    public <V, R extends Collection<V>> R collect(Function<? super T, ? extends V> var1, R var2);

    public BooleanIterable collectBoolean(BooleanFunction<? super T> var1);

    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super T> var1, R var2);

    public ByteIterable collectByte(ByteFunction<? super T> var1);

    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super T> var1, R var2);

    public CharIterable collectChar(CharFunction<? super T> var1);

    public <R extends MutableCharCollection> R collectChar(CharFunction<? super T> var1, R var2);

    public DoubleIterable collectDouble(DoubleFunction<? super T> var1);

    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super T> var1, R var2);

    public FloatIterable collectFloat(FloatFunction<? super T> var1);

    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super T> var1, R var2);

    public IntIterable collectInt(IntFunction<? super T> var1);

    public <R extends MutableIntCollection> R collectInt(IntFunction<? super T> var1, R var2);

    public LongIterable collectLong(LongFunction<? super T> var1);

    public <R extends MutableLongCollection> R collectLong(LongFunction<? super T> var1, R var2);

    public ShortIterable collectShort(ShortFunction<? super T> var1);

    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super T> var1, R var2);

    public <P, V> RichIterable<V> collectWith(Function2<? super T, ? super P, ? extends V> var1, P var2);

    public <P, V, R extends Collection<V>> R collectWith(Function2<? super T, ? super P, ? extends V> var1, P var2, R var3);

    public <V> RichIterable<V> collectIf(Predicate<? super T> var1, Function<? super T, ? extends V> var2);

    public <V, R extends Collection<V>> R collectIf(Predicate<? super T> var1, Function<? super T, ? extends V> var2, R var3);

    public <V> RichIterable<V> flatCollect(Function<? super T, ? extends Iterable<V>> var1);

    default public <P, V> RichIterable<V> flatCollectWith(Function2<? super T, ? super P, ? extends Iterable<V>> function, P parameter) {
        return this.flatCollect(each2 -> (Iterable)function.apply((Object)each2, (Object)parameter));
    }

    public <V, R extends Collection<V>> R flatCollect(Function<? super T, ? extends Iterable<V>> var1, R var2);

    default public <P, V, R extends Collection<V>> R flatCollectWith(Function2<? super T, ? super P, ? extends Iterable<V>> function, P parameter, R target) {
        return this.flatCollect(each2 -> (Iterable)function.apply((Object)each2, (Object)parameter), target);
    }

    public T detect(Predicate<? super T> var1);

    public <P> T detectWith(Predicate2<? super T, ? super P> var1, P var2);

    public Optional<T> detectOptional(Predicate<? super T> var1);

    public <P> Optional<T> detectWithOptional(Predicate2<? super T, ? super P> var1, P var2);

    default public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        T result = this.detect(predicate);
        return result == null ? function.value() : result;
    }

    public <P> T detectWithIfNone(Predicate2<? super T, ? super P> var1, P var2, Function0<? extends T> var3);

    public int count(Predicate<? super T> var1);

    public <P> int countWith(Predicate2<? super T, ? super P> var1, P var2);

    public boolean anySatisfy(Predicate<? super T> var1);

    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> var1, P var2);

    public boolean allSatisfy(Predicate<? super T> var1);

    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> var1, P var2);

    public boolean noneSatisfy(Predicate<? super T> var1);

    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> var1, P var2);

    public <IV> IV injectInto(IV var1, Function2<? super IV, ? super T, ? extends IV> var2);

    public int injectInto(int var1, IntObjectToIntFunction<? super T> var2);

    public long injectInto(long var1, LongObjectToLongFunction<? super T> var3);

    public float injectInto(float var1, FloatObjectToFloatFunction<? super T> var2);

    public double injectInto(double var1, DoubleObjectToDoubleFunction<? super T> var3);

    public <R extends Collection<T>> R into(R var1);

    public MutableList<T> toList();

    default public MutableList<T> toSortedList() {
        return this.toList().sortThis();
    }

    default public MutableList<T> toSortedList(Comparator<? super T> comparator) {
        return this.toList().sortThis(comparator);
    }

    public <V extends Comparable<? super V>> MutableList<T> toSortedListBy(Function<? super T, ? extends V> var1);

    public MutableSet<T> toSet();

    public MutableSortedSet<T> toSortedSet();

    public MutableSortedSet<T> toSortedSet(Comparator<? super T> var1);

    public <V extends Comparable<? super V>> MutableSortedSet<T> toSortedSetBy(Function<? super T, ? extends V> var1);

    public MutableBag<T> toBag();

    public MutableSortedBag<T> toSortedBag();

    public MutableSortedBag<T> toSortedBag(Comparator<? super T> var1);

    public <V extends Comparable<? super V>> MutableSortedBag<T> toSortedBagBy(Function<? super T, ? extends V> var1);

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super T, ? extends NK> var1, Function<? super T, ? extends NV> var2);

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super T, ? extends NK> var1, Function<? super T, ? extends NV> var2);

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> var1, Function<? super T, ? extends NK> var2, Function<? super T, ? extends NV> var3);

    default public <KK extends Comparable<? super KK>, NK, NV> MutableSortedMap<NK, NV> toSortedMapBy(Function<? super NK, KK> sortBy, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        throw new UnsupportedOperationException("Adding default implementation so as to not break compatibility");
    }

    public LazyIterable<T> asLazy();

    public Object[] toArray();

    public <T> T[] toArray(T[] var1);

    public T min(Comparator<? super T> var1);

    public T max(Comparator<? super T> var1);

    default public Optional<T> minOptional(Comparator<? super T> comparator) {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.min(comparator));
    }

    default public Optional<T> maxOptional(Comparator<? super T> comparator) {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.max(comparator));
    }

    public T min();

    public T max();

    default public Optional<T> minOptional() {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.min());
    }

    default public Optional<T> maxOptional() {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.max());
    }

    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> var1);

    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> var1);

    default public <V extends Comparable<? super V>> Optional<T> minByOptional(Function<? super T, ? extends V> function) {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.minBy(function));
    }

    default public <V extends Comparable<? super V>> Optional<T> maxByOptional(Function<? super T, ? extends V> function) {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.maxBy(function));
    }

    public long sumOfInt(IntFunction<? super T> var1);

    public double sumOfFloat(FloatFunction<? super T> var1);

    public long sumOfLong(LongFunction<? super T> var1);

    public double sumOfDouble(DoubleFunction<? super T> var1);

    default public IntSummaryStatistics summarizeInt(IntFunction<? super T> function) {
        IntSummaryStatistics stats = new IntSummaryStatistics();
        this.each(each2 -> stats.accept(function.intValueOf(each2)));
        return stats;
    }

    default public DoubleSummaryStatistics summarizeFloat(FloatFunction<? super T> function) {
        DoubleSummaryStatistics stats = new DoubleSummaryStatistics();
        this.each(each2 -> stats.accept(function.floatValueOf(each2)));
        return stats;
    }

    default public LongSummaryStatistics summarizeLong(LongFunction<? super T> function) {
        LongSummaryStatistics stats = new LongSummaryStatistics();
        this.each(each2 -> stats.accept(function.longValueOf(each2)));
        return stats;
    }

    default public DoubleSummaryStatistics summarizeDouble(DoubleFunction<? super T> function) {
        DoubleSummaryStatistics stats = new DoubleSummaryStatistics();
        this.each(each2 -> stats.accept(function.doubleValueOf(each2)));
        return stats;
    }

    default public <R, A> R reduceInPlace(Collector<? super T, A, R> collector) {
        Object mutableResult = collector.supplier().get();
        BiConsumer accumulator = collector.accumulator();
        this.each(each2 -> accumulator.accept(mutableResult, (Object)each2));
        return collector.finisher().apply(mutableResult);
    }

    default public <R> R reduceInPlace(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator) {
        Object result = supplier.get();
        this.each(each2 -> accumulator.accept(result, (Object)each2));
        return result;
    }

    default public Optional<T> reduce(BinaryOperator<T> accumulator) {
        boolean[] seenOne = new boolean[1];
        Object[] result = new Object[1];
        this.each(each2 -> {
            if (seenOne[0]) {
                result[0] = accumulator.apply(result[0], each2);
            } else {
                seenOne[0] = true;
                result[0] = each2;
            }
        });
        return seenOne[0] ? Optional.of(result[0]) : Optional.empty();
    }

    public <V> ObjectLongMap<V> sumByInt(Function<? super T, ? extends V> var1, IntFunction<? super T> var2);

    public <V> ObjectDoubleMap<V> sumByFloat(Function<? super T, ? extends V> var1, FloatFunction<? super T> var2);

    public <V> ObjectLongMap<V> sumByLong(Function<? super T, ? extends V> var1, LongFunction<? super T> var2);

    public <V> ObjectDoubleMap<V> sumByDouble(Function<? super T, ? extends V> var1, DoubleFunction<? super T> var2);

    default public String makeString() {
        return this.makeString(", ");
    }

    default public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    default public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    default public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    default public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable var1, String var2, String var3, String var4);

    public <V> Multimap<V, T> groupBy(Function<? super T, ? extends V> var1);

    default public <V> Bag<V> countBy(Function<? super T, ? extends V> function) {
        return this.asLazy().collect((Function)function).toBag();
    }

    default public <V, R extends MutableBagIterable<V>> R countBy(Function<? super T, ? extends V> function, R target) {
        return this.collect(function, target);
    }

    default public <V, P> Bag<V> countByWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.asLazy().collectWith(function, (Object)parameter).toBag();
    }

    default public <V, P, R extends MutableBagIterable<V>> R countByWith(Function2<? super T, ? super P, ? extends V> function, P parameter, R target) {
        return this.collectWith(function, parameter, target);
    }

    public <V, R extends MutableMultimap<V, T>> R groupBy(Function<? super T, ? extends V> var1, R var2);

    public <V> Multimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> var1);

    public <V, R extends MutableMultimap<V, T>> R groupByEach(Function<? super T, ? extends Iterable<V>> var1, R var2);

    public <V> MapIterable<V, T> groupByUniqueKey(Function<? super T, ? extends V> var1);

    public <V, R extends MutableMap<V, T>> R groupByUniqueKey(Function<? super T, ? extends V> var1, R var2);

    public String toString();

    @Deprecated
    public <S> RichIterable<Pair<T, S>> zip(Iterable<S> var1);

    @Deprecated
    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> var1, R var2);

    @Deprecated
    public RichIterable<Pair<T, Integer>> zipWithIndex();

    @Deprecated
    public <R extends Collection<Pair<T, Integer>>> R zipWithIndex(R var1);

    public RichIterable<RichIterable<T>> chunk(int var1);

    public <K, V> MapIterable<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> var1, Function0<? extends V> var2, Procedure2<? super V, ? super T> var3);

    public <K, V> MapIterable<K, V> aggregateBy(Function<? super T, ? extends K> var1, Function0<? extends V> var2, Function2<? super V, ? super T, ? extends V> var3);
}

