/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal.annotation;

import java.lang.annotation.Annotation;
import junitparams.Parameters;
import junitparams.custom.CustomParameters;
import junitparams.internal.annotation.CustomParametersDescriptor;
import org.junit.runners.model.FrameworkMethod;

public class FrameworkMethodAnnotations {
    private final FrameworkMethod frameworkMethod;

    public FrameworkMethodAnnotations(FrameworkMethod frameworkMethod) {
        this.frameworkMethod = frameworkMethod;
    }

    public boolean isParametrised() {
        return this.hasAnnotation(Parameters.class) || this.hasCustomParameters();
    }

    public Annotation[] allAnnotations() {
        return this.frameworkMethod.getAnnotations();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return this.frameworkMethod.getAnnotation(annotationType);
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotation) {
        return this.getAnnotation(annotation) != null;
    }

    public boolean hasCustomParameters() {
        return this.getCustomParameters() != null;
    }

    public CustomParametersDescriptor getCustomParameters() {
        CustomParameters customParameters = this.frameworkMethod.getAnnotation(CustomParameters.class);
        if (customParameters != null) {
            return new CustomParametersDescriptor(customParameters);
        }
        for (Annotation annotation : this.frameworkMethod.getAnnotations()) {
            customParameters = annotation.annotationType().getAnnotation(CustomParameters.class);
            if (customParameters == null) continue;
            return new CustomParametersDescriptor(customParameters, annotation);
        }
        return null;
    }
}

