/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.File;
import java.nio.file.Path;
import java.util.IdentityHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0003;<=B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\r\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u000f\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000eJ3\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0012\u001a\u0002H\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b\u00a2\u0006\u0002\u0010\u001cJ,\u0010\f\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\b\u0010\f\u001a\u0004\u0018\u00010\u00042\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00110\u001eH\u0086\b\u00a2\u0006\u0002\u0010\u001fJ,\u0010 \u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\b\u0010\f\u001a\u0004\u0018\u00010\u000e2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00110\u001eH\u0086\b\u00a2\u0006\u0002\u0010\"J\u001b\u0010#\u001a\u00020\u000b2\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u001b\u00a2\u0006\u0002\u0010%J,\u0010&\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\b\u0010\f\u001a\u0004\u0018\u00010\u000e2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00110\u001eH\u0086\b\u00a2\u0006\u0002\u0010\"J\u001b\u0010'\u001a\u00020\u000b2\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u001b\u00a2\u0006\u0002\u0010%J\u0017\u0010(\u001a\u00020\u000b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u001eH\u0086\bJ\u0017\u0010+\u001a\u00020\u000b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u001eH\u0086\bJ\u0010\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u0004\u0018\u00010\u000e2\u0006\u0010-\u001a\u00020.J\u0016\u00100\u001a\u0002012\u0006\u00102\u001a\u0002012\u0006\u00103\u001a\u00020*J\u0015\u00104\u001a\u00020\u00192\b\u00105\u001a\u0004\u0018\u000106\u00a2\u0006\u0002\u00107J\u0006\u00108\u001a\u00020\u0004J\u001b\u00109\u001a\u00020\u000b2\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u001b\u00a2\u0006\u0002\u0010%J\u001b\u0010:\u001a\u00020\u000b2\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u001b\u00a2\u0006\u0002\u0010%R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006>"}, d2={"Lorg/mapdb/Utils;", "", "()V", "FAKE_LOCK", "Ljava/util/concurrent/locks/Lock;", "LOG", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Ljava/util/logging/Logger;", "assertLocked", "", "lock", "assertReadLock", "Ljava/util/concurrent/locks/ReadWriteLock;", "assertWriteLock", "clone", "E", "value", "serializer", "Lorg/mapdb/Serializer;", "out", "Lorg/mapdb/DataOutput2;", "(Ljava/lang/Object;Lorg/mapdb/Serializer;Lorg/mapdb/DataOutput2;)Ljava/lang/Object;", "identityCount", "", "vals", "", "([Ljava/lang/Object;)I", "body", "Lkotlin/Function0;", "(Ljava/util/concurrent/locks/Lock;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "lockRead", "f", "(Ljava/util/concurrent/locks/ReadWriteLock;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "lockReadAll", "locks", "([Ljava/util/concurrent/locks/ReadWriteLock;)V", "lockWrite", "lockWriteAll", "logDebug", "msg", "", "logInfo", "newLock", "threadSafe", "", "newReadWriteLock", "pathChangeSuffix", "Ljava/nio/file/Path;", "path", "suffix", "roundDownToIntMAXVAL", "size", "", "(Ljava/lang/Long;)I", "singleEntryLock", "unlockReadAll", "unlockWriteAll", "SingleEntryLock", "SingleEntryReadWriteLock", "SingleProtectionLock", "mapdb"})
public final class Utils {
    @JvmField
    @NotNull
    public static final Lock FAKE_LOCK;
    private static final Logger LOG;
    public static final Utils INSTANCE;

    public final Logger getLOG() {
        return LOG;
    }

    @NotNull
    public final Path pathChangeSuffix(@NotNull Path path, @NotNull String suffix) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        Intrinsics.checkParameterIsNotNull(suffix, "suffix");
        StringBuilder stringBuilder = new StringBuilder();
        File file = path.toFile();
        Intrinsics.checkExpressionValueIsNotNull(file, "path.toFile()");
        Path path2 = new File(stringBuilder.append(file.getPath()).append(suffix).toString()).toPath();
        Intrinsics.checkExpressionValueIsNotNull(path2, "File(path.toFile().path + suffix).toPath()");
        return path2;
    }

    public final void logDebug(@NotNull Function0<String> msg) {
        Intrinsics.checkParameterIsNotNull(msg, "msg");
        if (this.getLOG().isLoggable(Level.FINE)) {
            this.getLOG().log(Level.FINE, msg.invoke());
        }
    }

    public final void logInfo(@NotNull Function0<String> msg) {
        Intrinsics.checkParameterIsNotNull(msg, "msg");
        if (this.getLOG().isLoggable(Level.INFO)) {
            this.getLOG().log(Level.INFO, msg.invoke());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E> E lockWrite(@Nullable ReadWriteLock lock, @NotNull Function0<? extends E> f) {
        Intrinsics.checkParameterIsNotNull(f, "f");
        if (lock != null) {
            lock.writeLock().lock();
        }
        try {
            E e = f.invoke();
            return e;
        }
        finally {
            InlineMarker.finallyStart(1);
            if (lock != null) {
                lock.writeLock().unlock();
            }
            InlineMarker.finallyEnd(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E> E lockRead(@Nullable ReadWriteLock lock, @NotNull Function0<? extends E> f) {
        Intrinsics.checkParameterIsNotNull(f, "f");
        if (lock != null) {
            lock.readLock().lock();
        }
        try {
            E e = f.invoke();
            return e;
        }
        finally {
            InlineMarker.finallyStart(1);
            if (lock != null) {
                lock.readLock().unlock();
            }
            InlineMarker.finallyEnd(1);
        }
    }

    public final void assertReadLock(@Nullable ReadWriteLock lock) {
        if (lock instanceof ReentrantReadWriteLock && ((ReentrantReadWriteLock)lock).getReadLockCount() == 0 && !((ReentrantReadWriteLock)lock).isWriteLockedByCurrentThread()) {
            throw (Throwable)((Object)new AssertionError((Object)"not read locked"));
        }
        if (lock instanceof SingleEntryReadWriteLock && ((SingleEntryReadWriteLock)lock).getLock().getReadLockCount() == 0 && !((SingleEntryReadWriteLock)lock).getLock().isWriteLockedByCurrentThread()) {
            throw (Throwable)((Object)new AssertionError((Object)"not read locked"));
        }
    }

    public final void assertWriteLock(@Nullable ReadWriteLock lock) {
        if (lock instanceof ReentrantReadWriteLock && !((ReentrantReadWriteLock)lock).isWriteLockedByCurrentThread()) {
            throw (Throwable)((Object)new AssertionError((Object)"not write locked"));
        }
        if (lock instanceof SingleEntryReadWriteLock && !((SingleEntryReadWriteLock)lock).getLock().isWriteLockedByCurrentThread()) {
            throw (Throwable)((Object)new AssertionError((Object)"not write locked"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E> E lock(@Nullable Lock lock, @NotNull Function0<? extends E> body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        Lock lock2 = lock;
        if (lock2 != null) {
            lock2.lock();
        }
        try {
            E e = body.invoke();
            return e;
        }
        finally {
            InlineMarker.finallyStart(1);
            Lock lock3 = lock;
            if (lock3 != null) {
                lock3.unlock();
            }
            InlineMarker.finallyEnd(1);
        }
    }

    public final int roundDownToIntMAXVAL(@Nullable Long size2) {
        Long l = size2;
        if (l == null) {
            Intrinsics.throwNpe();
        }
        if (l > (long)Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size2.longValue();
    }

    @NotNull
    public final Lock singleEntryLock() {
        ReentrantLock lock = new ReentrantLock();
        return new Lock(lock){
            private final /* synthetic */ ReentrantLock $$delegate_0;
            final /* synthetic */ ReentrantLock $lock;

            private final void ensureNotLocked() {
                if (this.$lock.isHeldByCurrentThread()) {
                    throw (Throwable)new IllegalMonitorStateException("already locked by current thread");
                }
            }

            public void lock() {
                this.ensureNotLocked();
                this.$lock.lock();
            }

            public void lockInterruptibly() {
                this.ensureNotLocked();
                this.$lock.lockInterruptibly();
            }
            {
                this.$lock = $captured_local_variable$0;
                this.$$delegate_0 = $captured_local_variable$0;
            }

            public Condition newCondition() {
                return this.$$delegate_0.newCondition();
            }

            public boolean tryLock() {
                return this.$$delegate_0.tryLock();
            }

            public boolean tryLock(long p0, TimeUnit p1) {
                return this.$$delegate_0.tryLock(p0, p1);
            }

            public void unlock() {
                this.$$delegate_0.unlock();
            }
        };
    }

    @Nullable
    public final Lock newLock(boolean threadSafe) {
        return threadSafe ? new ReentrantLock() : null;
    }

    @Nullable
    public final ReadWriteLock newReadWriteLock(boolean threadSafe) {
        return threadSafe ? new ReentrantReadWriteLock() : null;
    }

    public final void assertLocked(@Nullable Lock lock) {
        if (lock instanceof ReentrantLock && !((ReentrantLock)lock).isHeldByCurrentThread() || lock instanceof SingleEntryLock && !((SingleEntryLock)lock).getLock().isHeldByCurrentThread()) {
            throw (Throwable)((Object)new AssertionError((Object)"Not locked"));
        }
    }

    @JvmStatic
    public static final <E> E clone(E value, @NotNull Serializer<E> serializer, @NotNull DataOutput2 out) {
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        Intrinsics.checkParameterIsNotNull(out, "out");
        out.pos = 0;
        serializer.serialize(out, value);
        DataInput2.ByteArray in2 = new DataInput2.ByteArray(out.copyBytes());
        return serializer.deserialize(in2, out.pos);
    }

    @JvmStatic
    public static /* bridge */ /* synthetic */ Object clone$default(Object object, Serializer serializer, DataOutput2 dataOutput2, int n, Object object2) {
        if ((n & 4) != 0) {
            dataOutput2 = new DataOutput2();
        }
        return Utils.clone(object, serializer, dataOutput2);
    }

    public final void lockReadAll(@NotNull ReadWriteLock[] locks) {
        Intrinsics.checkParameterIsNotNull(locks, "locks");
        int i = 0;
        while (i < locks.length) {
            ReadWriteLock lock;
            if (locks[i++] == null) {
                continue;
            }
            if (lock.readLock().tryLock()) continue;
            --i;
            while (i > 0) {
                ReadWriteLock readWriteLock = locks[--i];
                if (readWriteLock == null) {
                    continue;
                }
                readWriteLock.readLock().unlock();
            }
            Thread.sleep(0L, 100000);
            i = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void unlockReadAll(@NotNull ReadWriteLock[] locks) {
        Intrinsics.checkParameterIsNotNull(locks, "locks");
        int n = locks.length - 1;
        boolean bl = false;
        while (n >= 0) {
            void i;
            ReadWriteLock readWriteLock = locks[i];
            if (readWriteLock == null) {
                Intrinsics.throwNpe();
            }
            readWriteLock.readLock().unlock();
            --i;
        }
    }

    public final void lockWriteAll(@NotNull ReadWriteLock[] locks) {
        Intrinsics.checkParameterIsNotNull(locks, "locks");
        int i = 0;
        while (i < locks.length) {
            ReadWriteLock lock;
            if (locks[i++] == null) {
                continue;
            }
            if (lock.writeLock().tryLock()) continue;
            --i;
            while (i > 0) {
                ReadWriteLock readWriteLock = locks[--i];
                if (readWriteLock == null) {
                    continue;
                }
                readWriteLock.writeLock().unlock();
            }
            Thread.sleep(0L, 100000);
            i = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void unlockWriteAll(@NotNull ReadWriteLock[] locks) {
        Intrinsics.checkParameterIsNotNull(locks, "locks");
        int n = locks.length - 1;
        boolean bl = false;
        while (n >= 0) {
            void i;
            ReadWriteLock lock = locks[i];
            if (lock != null) {
                lock.writeLock().unlock();
            }
            --i;
        }
    }

    public final int identityCount(@NotNull Object[] vals) {
        Intrinsics.checkParameterIsNotNull(vals, "vals");
        IdentityHashMap<Object, String> a = new IdentityHashMap<Object, String>();
        Object[] $receiver$iv = vals;
        int n = $receiver$iv.length;
        for (int i = 0; i < n; ++i) {
            Object element$iv;
            Object it = element$iv = $receiver$iv[i];
            a.put(it, "");
        }
        return a.size();
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
        FAKE_LOCK = new Lock(){

            public void unlock() {
            }

            public void lockInterruptibly() {
            }

            @NotNull
            public Condition newCondition() {
                throw (Throwable)new UnsupportedOperationException("condition not implemented on FakeLock");
            }

            public void lock() {
            }

            public boolean tryLock() {
                return true;
            }

            public boolean tryLock(long time, @NotNull TimeUnit unit) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)unit), "unit");
                return true;
            }
        };
        LOG = Logger.getLogger("org.mapdb");
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016R\u001e\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/mapdb/Utils$SingleProtectionLock;", "Ljava/util/concurrent/locks/Lock;", "name", "", "(Ljava/lang/String;)V", "locked", "", "getLocked", "()Z", "setLocked", "(Z)V", "getName", "()Ljava/lang/String;", "lock", "", "lockInterruptibly", "newCondition", "Ljava/util/concurrent/locks/Condition;", "tryLock", "time", "", "unit", "Ljava/util/concurrent/TimeUnit;", "unlock", "mapdb"})
    public static final class SingleProtectionLock
    implements Lock {
        private volatile boolean locked;
        @NotNull
        private final String name;

        public final boolean getLocked() {
            return this.locked;
        }

        public final void setLocked(boolean bl) {
            this.locked = bl;
        }

        @Override
        public void lockInterruptibly() {
            this.lock();
        }

        @Override
        @NotNull
        public Condition newCondition() {
            throw (Throwable)new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            this.lock();
            return true;
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) {
            Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
            this.lock();
            return true;
        }

        @Override
        public void unlock() {
            if (!this.locked) {
                throw (Throwable)new IllegalAccessError(this.name + ": Not locked");
            }
            this.locked = false;
        }

        @Override
        public void lock() {
            if (!this.locked) {
                throw (Throwable)new IllegalAccessError(this.name + ": Already locked");
            }
            this.locked = true;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public SingleProtectionLock(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            this.name = name;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0010\u001a\n \r*\u0004\u0018\u00010\b0\bH\u0096\u0001J\b\u0010\u0011\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/mapdb/Utils$SingleEntryReadWriteLock;", "Ljava/util/concurrent/locks/ReadWriteLock;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "(Ljava/util/concurrent/locks/ReentrantReadWriteLock;)V", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "newWriteLock", "Ljava/util/concurrent/locks/Lock;", "getNewWriteLock", "()Ljava/util/concurrent/locks/Lock;", "origWriteLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock$WriteLock;", "kotlin.jvm.PlatformType", "getOrigWriteLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock$WriteLock;", "readLock", "writeLock", "mapdb"})
    public static final class SingleEntryReadWriteLock
    implements ReadWriteLock {
        private final ReentrantReadWriteLock.WriteLock origWriteLock;
        @NotNull
        private final Lock newWriteLock;
        @NotNull
        private final ReentrantReadWriteLock lock;

        public final ReentrantReadWriteLock.WriteLock getOrigWriteLock() {
            return this.origWriteLock;
        }

        @NotNull
        public final Lock getNewWriteLock() {
            return this.newWriteLock;
        }

        @Override
        @NotNull
        public Lock writeLock() {
            return this.newWriteLock;
        }

        @NotNull
        public final ReentrantReadWriteLock getLock() {
            return this.lock;
        }

        public SingleEntryReadWriteLock(@NotNull ReentrantReadWriteLock lock) {
            Intrinsics.checkParameterIsNotNull(lock, "lock");
            this.lock = lock;
            this.origWriteLock = this.lock.writeLock();
            this.newWriteLock = new Lock(this){
                private final /* synthetic */ ReentrantReadWriteLock.WriteLock $$delegate_0;
                final /* synthetic */ SingleEntryReadWriteLock this$0;

                private final void ensureNotLocked() {
                    if (this.this$0.getLock().isWriteLockedByCurrentThread()) {
                        throw (Throwable)new IllegalMonitorStateException("already locked by current thread");
                    }
                }

                public void lock() {
                    this.ensureNotLocked();
                    this.this$0.getOrigWriteLock().lock();
                }

                public void lockInterruptibly() {
                    this.ensureNotLocked();
                    this.this$0.getOrigWriteLock().lockInterruptibly();
                }
                {
                    this.this$0 = $outer;
                    ReentrantReadWriteLock.WriteLock writeLock = $outer.getOrigWriteLock();
                    Intrinsics.checkExpressionValueIsNotNull(writeLock, "origWriteLock");
                    this.$$delegate_0 = writeLock;
                }

                public Condition newCondition() {
                    return this.$$delegate_0.newCondition();
                }

                public boolean tryLock() {
                    return this.$$delegate_0.tryLock();
                }

                public boolean tryLock(long p0, TimeUnit p1) {
                    return this.$$delegate_0.tryLock(p0, p1);
                }

                public void unlock() {
                    this.$$delegate_0.unlock();
                }
            };
        }

        public /* synthetic */ SingleEntryReadWriteLock(ReentrantReadWriteLock reentrantReadWriteLock, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                reentrantReadWriteLock = new ReentrantReadWriteLock();
            }
            this(reentrantReadWriteLock);
        }

        public SingleEntryReadWriteLock() {
            this(null, 1, null);
        }

        @Override
        public Lock readLock() {
            return this.lock.readLock();
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0002\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0011\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nH\u0096\u0001J\t\u0010\f\u001a\u00020\rH\u0096\u0001J!\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n \u000b*\u0004\u0018\u00010\u00110\u0011H\u0096\u0001J\t\u0010\u0012\u001a\u00020\u0007H\u0096\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/mapdb/Utils$SingleEntryLock;", "Ljava/util/concurrent/locks/Lock;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "(Ljava/util/concurrent/locks/ReentrantLock;)V", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "", "lockInterruptibly", "newCondition", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "tryLock", "", "p0", "", "p1", "Ljava/util/concurrent/TimeUnit;", "unlock", "mapdb"})
    public static final class SingleEntryLock
    implements Lock {
        @NotNull
        private final ReentrantLock lock;

        @Override
        public void lock() {
            if (this.lock.isHeldByCurrentThread()) {
                throw (Throwable)new IllegalMonitorStateException("already locked by current thread");
            }
            this.lock.lock();
        }

        @Override
        public void lockInterruptibly() {
            if (this.lock.isHeldByCurrentThread()) {
                throw (Throwable)new IllegalMonitorStateException("already locked by current thread");
            }
            this.lock.lockInterruptibly();
        }

        @NotNull
        public final ReentrantLock getLock() {
            return this.lock;
        }

        public SingleEntryLock(@NotNull ReentrantLock lock) {
            Intrinsics.checkParameterIsNotNull(lock, "lock");
            this.lock = lock;
        }

        public /* synthetic */ SingleEntryLock(ReentrantLock reentrantLock, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                reentrantLock = new ReentrantLock();
            }
            this(reentrantLock);
        }

        public SingleEntryLock() {
            this(null, 1, null);
        }

        @Override
        public Condition newCondition() {
            return this.lock.newCondition();
        }

        @Override
        public boolean tryLock() {
            return this.lock.tryLock();
        }

        @Override
        public boolean tryLock(long p0, TimeUnit p1) {
            return this.lock.tryLock(p0, p1);
        }

        @Override
        public void unlock() {
            this.lock.unlock();
        }
    }
}

