/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.set.primitive.CharSet;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedCharProcedure;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;

public final class ImmutableCharSetSerializationProxy
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private CharSet set;

    public ImmutableCharSetSerializationProxy() {
    }

    public ImmutableCharSetSerializationProxy(CharSet set) {
        this.set = set;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.set.size());
        try {
            this.set.forEach(new CheckedCharProcedure(){

                @Override
                public void safeValue(char item) throws Exception {
                    out.writeChar(item);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size2 = in.readInt();
        CharHashSet deserializedSet = new CharHashSet(size2);
        for (int i = 0; i < size2; ++i) {
            deserializedSet.add(in.readChar());
        }
        this.set = deserializedSet;
    }

    private Object readResolve() {
        return this.set.toImmutable();
    }
}

