/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.bag.primitive;

import java.util.StringJoiner;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.bag.Bag;
import org.eclipse.collections.api.bag.primitive.ImmutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.set.primitive.DoubleSet;
import org.eclipse.collections.api.tuple.primitive.DoubleIntPair;

public interface DoubleBag
extends DoubleIterable {
    public int sizeDistinct();

    @Override
    default public DoubleBag tap(DoubleProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    public DoubleBag selectByOccurrences(IntPredicate var1);

    default public DoubleBag selectDuplicates() {
        return this.selectByOccurrences(occurrences -> occurrences > 1);
    }

    default public DoubleSet selectUnique() {
        throw new UnsupportedOperationException("Adding default implementation so as to not break compatibility");
    }

    public ListIterable<DoubleIntPair> topOccurrences(int var1);

    public ListIterable<DoubleIntPair> bottomOccurrences(int var1);

    public int occurrencesOf(double var1);

    public void forEachWithOccurrences(DoubleIntProcedure var1);

    @Override
    public DoubleBag select(DoublePredicate var1);

    @Override
    public DoubleBag reject(DoublePredicate var1);

    public <V> Bag<V> collect(DoubleToObjectFunction<? extends V> var1);

    public boolean equals(Object var1);

    public int hashCode();

    public ImmutableDoubleBag toImmutable();

    default public String toStringOfItemToCount() {
        StringJoiner joiner = new StringJoiner(", ", "{", "}");
        this.forEachWithOccurrences((each2, occurrences) -> joiner.add(each2 + "=" + occurrences));
        return joiner.toString();
    }
}

