/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version.impl;

import com.github.zafarkhaja.semver.Version;
import net.ossindex.version.IVersion;
import net.ossindex.version.impl.SemanticVersion;

public class ExtendedSemanticVersion
extends SemanticVersion {
    private SemanticVersion tail;
    private String postfix;

    protected ExtendedSemanticVersion(int major, int minor, int patch, int build) {
        this.head = Version.forIntegers(major, minor, patch);
        this.tail = new SemanticVersion(build);
        this.significantDigits = 4;
    }

    protected ExtendedSemanticVersion(int major, int minor, int patch, int build, String postfix) {
        this.head = Version.forIntegers(major, minor, patch);
        this.tail = new SemanticVersion(build);
        this.postfix = postfix;
        this.significantDigits = 4;
    }

    @Override
    public int getBuild() {
        return this.tail.getMajor();
    }

    @Override
    public boolean isStable() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ExtendedSemanticVersion) {
            ExtendedSemanticVersion v = (ExtendedSemanticVersion)o;
            if (!this.head.equals(v.head)) {
                return false;
            }
            return this.tail.equals(v.tail);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.head != null) {
            return this.head.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public int compareTo(IVersion other) {
        if (other instanceof ExtendedSemanticVersion) {
            ExtendedSemanticVersion sv = (ExtendedSemanticVersion)other;
            int diff = this.head.compareTo(sv.head);
            if (diff != 0) {
                return diff;
            }
            return this.tail.compareTo(sv.tail);
        }
        if (other instanceof SemanticVersion) {
            SemanticVersion sv = (SemanticVersion)other;
            int diff = this.head.compareTo(sv.head);
            if (diff != 0) {
                return diff;
            }
            if (this.tail.getMajor() == 0) {
                return 0;
            }
            return 1;
        }
        return this.toString().compareTo(other.toString());
    }

    @Override
    public String toString() {
        if (this.postfix != null) {
            return this.head.toString() + "." + this.tail.getMajor() + "-" + this.postfix;
        }
        return this.head.toString() + "." + this.tail.getMajor();
    }

    @Override
    public boolean lessThan(IVersion version) {
        if (!(version instanceof SemanticVersion)) {
            return false;
        }
        if (this.head.lessThan(((SemanticVersion)version).head)) {
            return true;
        }
        if (this.head.greaterThan(((SemanticVersion)version).head)) {
            return false;
        }
        if (version instanceof ExtendedSemanticVersion) {
            return this.tail.lessThan(((ExtendedSemanticVersion)version).tail);
        }
        return false;
    }

    @Override
    public boolean lessThanOrEqualTo(IVersion version) {
        if (!(version instanceof SemanticVersion)) {
            return false;
        }
        if (this.head.lessThan(((SemanticVersion)version).head)) {
            return true;
        }
        if (this.head.greaterThan(((SemanticVersion)version).head)) {
            return false;
        }
        if (version instanceof ExtendedSemanticVersion) {
            return this.tail.lessThanOrEqualTo(((ExtendedSemanticVersion)version).tail);
        }
        return this.tail.getMajor() == 0;
    }

    @Override
    public boolean greaterThan(IVersion version) {
        if (!(version instanceof SemanticVersion)) {
            return false;
        }
        if (this.head.greaterThan(((SemanticVersion)version).head)) {
            return true;
        }
        if (this.head.lessThan(((SemanticVersion)version).head)) {
            return false;
        }
        if (version instanceof ExtendedSemanticVersion) {
            return this.tail.greaterThan(((ExtendedSemanticVersion)version).tail);
        }
        return true;
    }

    @Override
    public boolean greaterThanOrEqualTo(IVersion version) {
        if (!(version instanceof SemanticVersion)) {
            return false;
        }
        if (this.head.greaterThan(((SemanticVersion)version).head)) {
            return true;
        }
        if (this.head.lessThan(((SemanticVersion)version).head)) {
            return false;
        }
        if (version instanceof ExtendedSemanticVersion) {
            return this.tail.greaterThanOrEqualTo(((ExtendedSemanticVersion)version).tail);
        }
        return this.tail.getMajor() >= 0;
    }

    @Override
    public SemanticVersion getNextVersion() {
        int major = this.head.getMajorVersion();
        int minor = this.head.getMinorVersion();
        int patch = this.head.getPatchVersion();
        int build = this.tail.getMajor();
        return new ExtendedSemanticVersion(major, minor, patch, build + 1);
    }

    @Override
    public SemanticVersion getNextParentVersion() {
        int major = this.head.getMajorVersion();
        int minor = this.head.getMinorVersion();
        int patch = this.head.getPatchVersion();
        int build = this.tail.getMajor();
        switch (this.significantDigits) {
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                minor = 0;
                patch = 0;
                build = 0;
                return new ExtendedSemanticVersion(++major, minor, patch, build);
            }
            case 3: {
                patch = 0;
                build = 0;
                return new ExtendedSemanticVersion(major, ++minor, patch, build);
            }
            case 4: {
                build = 0;
                return new ExtendedSemanticVersion(major, minor, ++patch, build);
            }
        }
        throw new UnsupportedOperationException();
    }
}

