/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal.parameters;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import junitparams.Parameters;
import org.junit.runners.model.FrameworkMethod;

class ParamsFromMethodCommon {
    private FrameworkMethod frameworkMethod;

    ParamsFromMethodCommon(FrameworkMethod frameworkMethod) {
        this.frameworkMethod = frameworkMethod;
    }

    Object[] paramsFromMethod(Class<?> sourceClass) {
        String methodAnnotation = this.frameworkMethod.getAnnotation(Parameters.class).method();
        if (methodAnnotation.isEmpty()) {
            return this.invokeMethodWithParams(this.defaultMethodName(), sourceClass);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (String methodName : methodAnnotation.split(",")) {
            for (Object param : this.invokeMethodWithParams(methodName.trim(), sourceClass)) {
                result.add(param);
            }
        }
        return result.toArray();
    }

    Object[] getDataFromMethod(Method providerMethod) throws IllegalAccessException, InvocationTargetException {
        return this.encapsulateParamsIntoArrayIfSingleParamsetPassed((Object[])providerMethod.invoke(null, new Object[0]));
    }

    boolean containsDefaultParametersProvidingMethod(Class<?> sourceClass) {
        return this.findMethodInTestClassHierarchy(this.defaultMethodName(), sourceClass) != null;
    }

    private String defaultMethodName() {
        return "parametersFor" + this.frameworkMethod.getName().substring(0, 1).toUpperCase() + this.frameworkMethod.getName().substring(1);
    }

    private Object[] invokeMethodWithParams(String methodName, Class<?> sourceClass) {
        Method providerMethod = this.findMethodInTestClassHierarchy(methodName, sourceClass);
        if (providerMethod == null) {
            throw new RuntimeException("Could not find method: " + methodName + " so no params were used.");
        }
        return this.invokeParamsProvidingMethod(providerMethod, sourceClass);
    }

    private Object[] invokeParamsProvidingMethod(Method provideMethod, Class<?> sourceClass) {
        try {
            Object testObject = sourceClass.newInstance();
            provideMethod.setAccessible(true);
            Object result = provideMethod.invoke(testObject, new Object[0]);
            if (Object[].class.isAssignableFrom(result.getClass())) {
                Object[] params = (Object[])result;
                return this.encapsulateParamsIntoArrayIfSingleParamsetPassed(params);
            }
            if (Iterable.class.isAssignableFrom(result.getClass())) {
                try {
                    ArrayList<Object[]> res = new ArrayList<Object[]>();
                    for (Object[] paramSet : (Iterable)result) {
                        res.add(paramSet);
                    }
                    return res.toArray();
                }
                catch (ClassCastException e1) {
                    ArrayList<Object[]> res = new ArrayList<Object[]>();
                    for (Object param : (Iterable)result) {
                        res.add(new Object[]{param});
                    }
                    return res.toArray();
                }
            }
            if (Iterator.class.isAssignableFrom(result.getClass())) {
                Object iteratedElement = null;
                try {
                    ArrayList<Object[]> res = new ArrayList<Object[]>();
                    Iterator iterator2 = (Iterator)result;
                    while (iterator2.hasNext()) {
                        iteratedElement = iterator2.next();
                        res.add((Object[])iteratedElement);
                    }
                    return res.toArray();
                }
                catch (ClassCastException e1) {
                    ArrayList<Object[]> res = new ArrayList<Object[]>();
                    Iterator iterator3 = (Iterator)result;
                    res.add((Object[])iteratedElement);
                    while (iterator3.hasNext()) {
                        res.add(new Object[]{iterator3.next()});
                    }
                    return res.toArray();
                }
            }
            throw new ClassCastException();
        }
        catch (ClassCastException e) {
            throw new RuntimeException("The return type of: " + provideMethod.getName() + " defined in class " + sourceClass + " is not Object[][] nor Iterable<Object[]>. Fix it!", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not invoke method: " + provideMethod.getName() + " defined in class " + sourceClass + " so no params were used.", e);
        }
    }

    private Method findMethodInTestClassHierarchy(String methodName, Class<?> sourceClass) {
        Class<?> declaringClass = sourceClass;
        while (declaringClass.getSuperclass() != null) {
            try {
                return declaringClass.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (Exception exception) {
                declaringClass = declaringClass.getSuperclass();
            }
        }
        return null;
    }

    private Object[] encapsulateParamsIntoArrayIfSingleParamsetPassed(Object[] params) {
        if (this.frameworkMethod.getMethod().getParameterTypes().length != params.length) {
            return params;
        }
        if (params.length == 0) {
            return params;
        }
        Object param = params[0];
        if (param == null || !param.getClass().isArray()) {
            return new Object[]{params};
        }
        return params;
    }
}

