package net.ossindex.common.filter;

import java.util.List;

import net.ossindex.common.PackageCoordinate;

public class VulnerabilityFilterFactory
{
  private static VulnerabilityFilterFactory instance;

  private VulnerabilityFilterFactory() {
  }

  public static synchronized VulnerabilityFilterFactory getInstance() {
    if (instance == null) {
      instance = new VulnerabilityFilterFactory();
    }
    return instance;
  }

  public IVulnerabilityFilter createVulnerabilityFilter() {
    return new VulnerabilityFilterImpl();
  }

  /**
   * Kind of filthy this being here. It is in lieu of making a separate utility class for now. It allows us to run
   * the filter without exposing private functionality to the users.
   */
  public static boolean shouldFilter(final IVulnerabilityFilter filter,
                                  final List<PackageCoordinate> path,
                                  final String vid) {
    return ((VulnerabilityFilterImpl)filter).shouldFilter(path, vid);
  }
}
