/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.common.request;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import net.ossindex.common.IFromTillRequest;
import net.ossindex.common.PackageDescriptor;
import net.ossindex.common.request.AbstractOssIndexRequest;
import net.ossindex.common.request.FromTillResponse;

public class FromTillRequest
extends AbstractOssIndexRequest
implements Iterator<Collection<PackageDescriptor>>,
Iterable<Collection<PackageDescriptor>>,
IFromTillRequest {
    private Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private String pm;
    private long from;
    private long till;

    public FromTillRequest(String pm) {
        this.pm = pm;
        this.from = 0L;
        this.till = Long.MAX_VALUE;
    }

    public FromTillRequest(String pm, long from, long till) {
        this.pm = pm;
        this.from = from;
        this.till = till < 0L ? Long.MAX_VALUE : till;
    }

    @Override
    public Iterator<Collection<PackageDescriptor>> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.from < this.till;
    }

    @Override
    public Collection<PackageDescriptor> next() {
        String query = "vulnerability/pm/" + this.pm + "/fromtill/" + this.from + "/" + this.till;
        try {
            String json = this.performGetRequest(query);
            FromTillResponse response = (FromTillResponse)this.gson.fromJson(json, FromTillResponse.class);
            System.err.println("FROMTILL:");
            System.err.println("  REQUESTED FROM: " + response.getRequestedFrom());
            System.err.println("  REQUESTED TILL: " + response.getRequestedTill());
            System.err.println("  ACTUAL FROM:    " + response.getActualFrom());
            System.err.println("  NEXT:           " + response.getNext());
            this.till = response.getActualFrom() - 1L;
            return response.getPackages();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

