/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.common;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

public class VulnerabilityDescriptor {
    @XmlElement(name="id")
    private Long id = 0L;
    @XmlElement(name="title")
    private String title;
    @XmlElement(name="description")
    private String description;
    @XmlElementWrapper(name="versions")
    @XmlElement(name="version")
    private List<String> versions;
    @XmlElementWrapper(name="references")
    @XmlElement(name="reference")
    private List<String> references;
    @XmlElement(name="published")
    private long published;
    @XmlElement(name="updated")
    private long updated;
    @XmlElement(name="cve")
    private String cve;

    public long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public List<String> getReferences() {
        return this.references;
    }

    public long getPublished() {
        return this.published;
    }

    public Date getPublishedDate() {
        return new Date(this.published);
    }

    public long getUpdated() {
        return this.updated;
    }

    public Date getUpdatedDate() {
        return new Date(this.updated);
    }

    public String getUriString() {
        if (this.isCve()) {
            return "https://ossindex.net/resource/cve/" + this.id;
        }
        return "https://ossindex.net/resource/vulnerability/" + this.id;
    }

    public boolean isCve() {
        return this.cve != null;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof VulnerabilityDescriptor) {
            return this.id.equals(((VulnerabilityDescriptor)o).id);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.id).append("] ").append(this.title).append(" (");
        if (this.versions != null) {
            Iterator<String> it = this.versions.iterator();
            while (it.hasNext()) {
                String version = it.next();
                sb.append(version);
                if (!it.hasNext()) continue;
                sb.append(" || ");
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

