package net.ossindex.common.request;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import net.ossindex.common.IFromTillRequest;
import net.ossindex.common.PackageDescriptor;

/** Implements vulnerability queries
 * 
 * @author Ken Duck
 *
 */
public class FromTillRequest extends AbstractOssIndexRequest implements Iterator<Collection<PackageDescriptor>>, Iterable<Collection<PackageDescriptor>>, IFromTillRequest {
	private Gson gson = new GsonBuilder().disableHtmlEscaping().create();

	private String pm;
	private long from;
	private long till;

	/**
	 * From beginning Till end
	 * @param pm
	 */
	public FromTillRequest(String pm) {
		this.pm = pm;
		this.from = 0;
		this.till = Long.MAX_VALUE;
	}

	public FromTillRequest(String pm, long from, long till) {
		this.pm = pm;
		this.from = from;
		if (till < 0) {
			this.till = Long.MAX_VALUE;
		} else {
			this.till = till;
		}
	}

	/*
	 * (non-Javadoc)
	 * @see java.lang.Iterable#iterator()
	 */
	@Override
	public Iterator<Collection<PackageDescriptor>> iterator() {
		return this;
	}

	@Override
	public boolean hasNext() {
		return from < till;
	}

	@Override
	public Collection<PackageDescriptor> next() {
		// Perform the OSS Index query
		String query = "vulnerability/pm/" + pm + "/fromtill/" + from + "/" + till;
		try {
			String json = this.performGetRequest(query);
//			System.err.println(json);
			
			FromTillResponse response = gson.fromJson(json, FromTillResponse.class);
			
			System.err.println("FROMTILL:");
			System.err.println("  REQUESTED FROM: " + response.getRequestedFrom());
			System.err.println("  REQUESTED TILL: " + response.getRequestedTill());
			System.err.println("  ACTUAL FROM:    " + response.getActualFrom());
			System.err.println("  NEXT:           " + response.getNext());
			till = response.getActualFrom() - 1;

			return response.getPackages();
		} catch (IOException e) {
			throw new AssertionError(e);
		}
	}
}

class FromTillResponse {
	private List<PackageDescriptor> packages;
	private Long requestedFrom;
	private Long requestedTill;
	private Long actualFrom;
	private String next;
	
	public List<PackageDescriptor> getPackages() {
		return packages;
	}

	/**
	 * @return the requestedFrom
	 */
	public Long getRequestedFrom() {
		return requestedFrom;
	}

	/**
	 * @return the requestedTill
	 */
	public Long getRequestedTill() {
		return requestedTill;
	}

	/**
	 * @return the actualFrom
	 */
	public Long getActualFrom() {
		return actualFrom;
	}

	/**
	 * @return the next
	 */
	public String getNext() {
		return next;
	}
}