/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.common.request;

import java.io.IOException;
import java.net.ConnectException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class AbstractOssIndexRequest {
    private static final String BASE_URL = "https://ossindex.net/v2.0/";

    protected String performPostRequest(String requestString, String data) throws IOException {
        HttpPost request = new HttpPost(this.getBaseUrl() + requestString);
        String json = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            request.setEntity((HttpEntity)new StringEntity(data));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            int code = response.getStatusLine().getStatusCode();
            if (code < 200 || code > 299) {
                throw new ConnectException(response.getStatusLine().getReasonPhrase() + " (" + code + ")");
            }
            json = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        return json;
    }

    private String getBaseUrl() {
        return BASE_URL;
    }
}

