/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.common;

import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class VulnerabilityDescriptor {
    private long id;
    private String title;
    private String description;
    private List<String> versions;
    private List<String> references;
    private long published;
    private long updated;
    private String cve;

    public long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public List<String> getReferences() {
        return this.references;
    }

    public long getPublished() {
        return this.published;
    }

    public Date getPublishedDate() {
        return new Date(this.published);
    }

    public long getUpdated() {
        return this.updated;
    }

    public Date getUpdatedDate() {
        return new Date(this.updated);
    }

    public String getUriString() {
        if (this.isCve()) {
            return "https://ossindex.net/resource/cve/" + this.id;
        }
        return "https://ossindex.net/resource/vulnerability/" + this.id;
    }

    public boolean isCve() {
        return this.cve != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.id).append("] ").append(this.title).append(" (");
        if (this.versions != null) {
            Iterator<String> it = this.versions.iterator();
            while (it.hasNext()) {
                String version = it.next();
                sb.append(version);
                if (!it.hasNext()) continue;
                sb.append(" || ");
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

