/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.examples;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import net.ossindex.common.ResourceFactory;
import net.ossindex.common.resource.FileResource;

public class LsOss {
    private boolean verbose;
    private File[] files;

    public LsOss(String[] args) {
        int i = 0;
        if (args.length > 0 && "-v".equals(args[i])) {
            this.verbose = true;
            ++i;
        }
        if (i >= args.length) {
            this.usage();
        }
        LinkedList<File> files = new LinkedList<File>();
        while (i < args.length) {
            File file = new File(args[i]);
            if (file.exists() && file.isFile()) {
                files.add(file);
            }
            ++i;
        }
        this.files = files.toArray(new File[files.size()]);
    }

    private void run() throws IOException {
        FileResource[] resources = ResourceFactory.getResourceFactory().findFileResources(this.files);
        if (resources == null) {
            throw new IOException("Unexpected results from FileResource.find(...)");
        }
        if (resources.length != this.files.length) {
            throw new IOException("Mismatch between request size and response size. " + this.files.length + " != " + resources.length);
        }
        if (this.verbose) {
            System.out.println("The following files were found in the OSS Index:");
        }
        int identified = 0;
        for (int i = 0; i < resources.length; ++i) {
            if (resources[i] == null) continue;
            ++identified;
            if (this.verbose) {
                System.out.print("  ");
            }
            System.out.println(this.files[i].getAbsolutePath());
        }
        if (this.verbose) {
            System.out.println("Checked " + this.files.length + " files");
            System.out.println("Identified " + identified + " files");
        }
    }

    private void usage() {
        System.err.println("Usage: lsoss [options] <file> [file...]");
        System.err.println();
        System.err.println("Identify files that are open source (found in OSS Index)");
        System.err.println();
        System.err.println(" options:");
        System.err.println();
        System.err.println("   -v    Verbose output");
        System.err.println();
        System.err.println("Limitation: Command will fail with exit code if too many files");
        System.err.println("            are passed on the command line, or if there are");
        System.err.println("            connection problems with the server");
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        LsOss lsoss = new LsOss(args);
        lsoss.run();
    }
}

