/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.common.resource;

import java.net.URI;
import java.net.URISyntaxException;
import net.ossindex.common.resource.AbstractRemoteResource;
import net.ossindex.version.IVersionRange;
import net.ossindex.version.VersionFactory;

public class VulnerabilityResource
extends AbstractRemoteResource {
    private String complexity;
    private String vector;
    private String authentication;
    private String availability;
    private String confidentiality;
    private String integrity;
    private String source;
    private String security_protection;
    private Long discovered;
    private Long generated;
    private Long published;
    private Long modified;
    private String cveId;
    private String uri;
    private String title;
    private String summary;
    private String details;
    private String[] versions;

    @Override
    protected String getResourceType() {
        return "vulnerability";
    }

    public boolean isCve() {
        return this.getId() > 0L;
    }

    public URI getUri() {
        if (this.uri != null) {
            try {
                return new URI(this.uri);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String[] getVersions() {
        return this.versions;
    }

    public String getDescription() {
        if (this.summary != null) {
            return this.summary;
        }
        return this.uri.toString();
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        return this.uri.toString();
    }

    public boolean affects(String name, String range) {
        return this.appliesTo(range);
    }

    public boolean appliesTo(String range) {
        if (this.versions != null) {
            IVersionRange[] ranges = new IVersionRange[this.versions.length];
            for (int i = 0; i < this.versions.length; ++i) {
                ranges[i] = VersionFactory.getRange((String)this.versions[i]);
            }
            IVersionRange yourRange = VersionFactory.getRange((String)range);
            for (int i = 0; i < ranges.length; ++i) {
                if (!ranges[i].intersects(yourRange)) continue;
                return true;
            }
        }
        return false;
    }
}

