/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.common.resource;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.ossindex.common.ResourceFactory;
import net.ossindex.common.resource.AbstractRemoteResource;
import net.ossindex.common.resource.ArtifactResource;

public class PackageResource
extends AbstractRemoteResource
implements Comparable<PackageResource> {
    private String name;
    private long creation_date;
    private long update_date;
    private String description;

    PackageResource() {
    }

    public PackageResource(long id) {
        super(id);
    }

    @Override
    protected String getResourceType() {
        return "package";
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getCreationDate() {
        if (this.creation_date > 0L) {
            return new Date(this.creation_date);
        }
        return null;
    }

    public Date getUpdateDate() {
        if (this.update_date > 0L) {
            return new Date(this.update_date);
        }
        return null;
    }

    @Override
    public int compareTo(PackageResource res) {
        if (res == null) {
            return 1;
        }
        if (this.name != null) {
            if (res.name != null) {
                return this.name.compareTo(res.name);
            }
            return 1;
        }
        if (res.name != null) {
            return -1;
        }
        if (this.getId() > res.getId()) {
            return 1;
        }
        if (this.getId() < res.getId()) {
            return -1;
        }
        return 0;
    }

    public ArtifactResource[] getArtifacts() {
        try {
            TypeToken<ArrayList<ArtifactResource>> type = new TypeToken<ArrayList<ArtifactResource>>(){};
            List<ArtifactResource> results = ResourceFactory.getResourceFactory().getResources(type, "/v1.0/package/" + this.getId() + "/artifacts");
            if (results != null) {
                AbstractRemoteResource[] resources = results.toArray(new ArtifactResource[results.size()]);
                ResourceFactory.getResourceFactory().cacheResources(resources);
                return resources;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

